@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.GetVolumeGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property elasticSanName The name of the ElasticSan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeGroupName The name of the VolumeGroup.
 */
public data class GetVolumeGroupPlainArgs(
    public val elasticSanName: String,
    public val resourceGroupName: String,
    public val volumeGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.GetVolumeGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.GetVolumeGroupPlainArgs =
        com.pulumi.azurenative.elasticsan.inputs.GetVolumeGroupPlainArgs.builder()
            .elasticSanName(elasticSanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeGroupName(volumeGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumeGroupPlainArgs].
 */
@PulumiTagMarker
public class GetVolumeGroupPlainArgsBuilder internal constructor() {
    private var elasticSanName: String? = null

    private var resourceGroupName: String? = null

    private var volumeGroupName: String? = null

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("cmnsbypxreujgcxf")
    public suspend fun elasticSanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.elasticSanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oeibmaijmyxheupn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("svpnuaacffljxcfd")
    public suspend fun volumeGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeGroupName = mapped
    }

    internal fun build(): GetVolumeGroupPlainArgs = GetVolumeGroupPlainArgs(
        elasticSanName = elasticSanName ?: throw PulumiNullFieldException("elasticSanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeGroupName = volumeGroupName ?: throw PulumiNullFieldException("volumeGroupName"),
    )
}
