@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.SnapshotCreationDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data used when creating a volume snapshot.
 * @property sourceId Fully qualified resource ID of the volume. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"
 */
public data class SnapshotCreationDataArgs(
    public val sourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.SnapshotCreationDataArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.SnapshotCreationDataArgs =
        com.pulumi.azurenative.elasticsan.inputs.SnapshotCreationDataArgs.builder()
            .sourceId(sourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotCreationDataArgs].
 */
@PulumiTagMarker
public class SnapshotCreationDataArgsBuilder internal constructor() {
    private var sourceId: Output<String>? = null

    /**
     * @param value Fully qualified resource ID of the volume. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"
     */
    @JvmName("ypbgfcnpkkqifiqg")
    public suspend fun sourceId(`value`: Output<String>) {
        this.sourceId = value
    }

    /**
     * @param value Fully qualified resource ID of the volume. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"
     */
    @JvmName("jveksccrwoeiatka")
    public suspend fun sourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceId = mapped
    }

    internal fun build(): SnapshotCreationDataArgs = SnapshotCreationDataArgs(
        sourceId = sourceId ?: throw PulumiNullFieldException("sourceId"),
    )
}
