@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Response for ElasticSan request.
 * @property availabilityZones Logical zone for Elastic San resource; example: ["1"].
 * @property baseSizeTiB Base size of the Elastic San appliance in TiB.
 * @property extendedCapacitySizeTiB Extended size of the Elastic San appliance in TiB.
 * @property id Azure resource identifier.
 * @property location The geo-location where the resource lives.
 * @property name Azure resource name.
 * @property provisioningState State of the operation on the resource.
 * @property sku resource sku
 * @property systemData Resource metadata required by ARM RPC
 * @property tags Azure resource tags.
 * @property totalIops Total Provisioned IOPS of the Elastic San appliance.
 * @property totalMBps Total Provisioned MBps Elastic San appliance.
 * @property totalSizeTiB Total size of the Elastic San appliance in TB.
 * @property totalVolumeSizeGiB Total size of the provisioned Volumes in GiB.
 * @property type Azure resource type.
 * @property volumeGroupCount Total number of volume groups in this Elastic San appliance.
 */
public data class GetElasticSanResult(
    public val availabilityZones: List<String>? = null,
    public val baseSizeTiB: Double,
    public val extendedCapacitySizeTiB: Double,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val totalIops: Double,
    public val totalMBps: Double,
    public val totalSizeTiB: Double,
    public val totalVolumeSizeGiB: Double,
    public val type: String,
    public val volumeGroupCount: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.outputs.GetElasticSanResult): GetElasticSanResult = GetElasticSanResult(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            baseSizeTiB = javaType.baseSizeTiB(),
            extendedCapacitySizeTiB = javaType.extendedCapacitySizeTiB(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.elasticsan.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalIops = javaType.totalIops(),
            totalMBps = javaType.totalMBps(),
            totalSizeTiB = javaType.totalSizeTiB(),
            totalVolumeSizeGiB = javaType.totalVolumeSizeGiB(),
            type = javaType.type(),
            volumeGroupCount = javaType.volumeGroupCount(),
        )
    }
}
