@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Response for Volume request.
 * @property creationData State of the operation on the resource.
 * @property id Azure resource identifier.
 * @property name Azure resource name.
 * @property sizeGiB Volume size.
 * @property storageTarget Storage target information
 * @property systemData Resource metadata required by ARM RPC
 * @property tags Azure resource tags.
 * @property type Azure resource type.
 * @property volumeId Unique Id of the volume in GUID format
 */
public data class GetVolumeResult(
    public val creationData: SourceCreationDataResponse? = null,
    public val id: String,
    public val name: String,
    public val sizeGiB: Double? = null,
    public val storageTarget: IscsiTargetInfoResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val volumeId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.outputs.GetVolumeResult): GetVolumeResult = GetVolumeResult(
            creationData = javaType.creationData().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elasticsan.kotlin.outputs.SourceCreationDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            sizeGiB = javaType.sizeGiB().map({ args0 -> args0 }).orElse(null),
            storageTarget = javaType.storageTarget().let({ args0 ->
                com.pulumi.azurenative.elasticsan.kotlin.outputs.IscsiTargetInfoResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            volumeId = javaType.volumeId(),
        )
    }
}
