@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Response for Volume Snapshot request.
 * @property creationData Data used when creating a volume snapshot.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState State of the operation on the resource.
 * @property sourceVolumeSizeGiB Size of Source Volume
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property volumeName Source Volume Name of a snapshot
 */
public data class GetVolumeSnapshotResult(
    public val creationData: SnapshotCreationDataResponse,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val sourceVolumeSizeGiB: Double,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val volumeName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.outputs.GetVolumeSnapshotResult): GetVolumeSnapshotResult = GetVolumeSnapshotResult(
            creationData = javaType.creationData().let({ args0 ->
                com.pulumi.azurenative.elasticsan.kotlin.outputs.SnapshotCreationDataResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sourceVolumeSizeGiB = javaType.sourceVolumeSizeGiB(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            volumeName = javaType.volumeName(),
        )
    }
}
