@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SKU name. Required for account creation; optional for update.
 * @property name The sku name.
 * @property tier The sku tier.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.outputs.SkuResponse): SkuResponse = SkuResponse(
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
