@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin

import com.pulumi.azurenative.engagementfabric.AccountArgs.builder
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.SKUArgs
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.SKUArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The EngagementFabric account
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### AccountsCreateOrUpdateExample
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.EngagementFabric.Account("account", new()
 *     {
 *         AccountName = "ExampleAccount",
 *         Location = "WestUS",
 *         ResourceGroupName = "ExampleRg",
 *         Sku = new AzureNative.EngagementFabric.Inputs.SKUArgs
 *         {
 *             Name = "B1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/engagementfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := engagementfabric.NewAccount(ctx, "account", &engagementfabric.AccountArgs{
 * 			AccountName:       pulumi.String("ExampleAccount"),
 * 			Location:          pulumi.String("WestUS"),
 * 			ResourceGroupName: pulumi.String("ExampleRg"),
 * 			Sku: &engagementfabric.SKUArgs{
 * 				Name: pulumi.String("B1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.engagementfabric.Account;
 * import com.pulumi.azurenative.engagementfabric.AccountArgs;
 * import com.pulumi.azurenative.engagementfabric.inputs.SKUArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("ExampleAccount")
 *             .location("WestUS")
 *             .resourceGroupName("ExampleRg")
 *             .sku(SKUArgs.builder()
 *                 .name("B1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:engagementfabric:Account ExampleAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EngagementFabric/Accounts/{accountName}
 * ```
 * @property accountName Account Name
 * @property location The location of the resource
 * @property resourceGroupName Resource Group Name
 * @property sku The SKU of the resource
 * @property tags The tags of the resource
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SKUArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.engagementfabric.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.engagementfabric.AccountArgs =
        com.pulumi.azurenative.engagementfabric.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SKUArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Account Name
     */
    @JvmName("augsisygvjuquyci")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The location of the resource
     */
    @JvmName("uwjxuqqfijkfkjcp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("lguigsqhivklmuqp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the resource
     */
    @JvmName("kbigbxnkpvcunuoh")
    public suspend fun sku(`value`: Output<SKUArgs>) {
        this.sku = value
    }

    /**
     * @param value The tags of the resource
     */
    @JvmName("mhpgduxavupwwepy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Account Name
     */
    @JvmName("ubecjphspsxgqwtl")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The location of the resource
     */
    @JvmName("jfquysmviowxeolk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("cbbnfpggpkhvqnqf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the resource
     */
    @JvmName("bxhmetxofvhhfcoq")
    public suspend fun sku(`value`: SKUArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the resource
     */
    @JvmName("ejfvumejtgppeexp")
    public suspend fun sku(argument: suspend SKUArgsBuilder.() -> Unit) {
        val toBeMapped = SKUArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The tags of the resource
     */
    @JvmName("phiqmwngalxjglac")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource
     */
    @JvmName("fxgkvpihuuiasyud")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
