@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin

import com.pulumi.azurenative.engagementfabric.ChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The EngagementFabric channel
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### ChannelsCreateOrUpdateExample
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.EngagementFabric.Channel("channel", new()
 *     {
 *         AccountName = "ExampleAccount",
 *         ChannelFunctions = new[]
 *         {
 *             "MockFunction1",
 *             "MockFunction2",
 *         },
 *         ChannelName = "ExampleChannel",
 *         ChannelType = "MockChannel",
 *         Credentials =
 *         {
 *             { "AppId", "exampleApp" },
 *             { "AppKey", "exampleAppKey" },
 *         },
 *         ResourceGroupName = "ExampleRg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/engagementfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := engagementfabric.NewChannel(ctx, "channel", &engagementfabric.ChannelArgs{
 * 			AccountName: pulumi.String("ExampleAccount"),
 * 			ChannelFunctions: pulumi.StringArray{
 * 				pulumi.String("MockFunction1"),
 * 				pulumi.String("MockFunction2"),
 * 			},
 * 			ChannelName: pulumi.String("ExampleChannel"),
 * 			ChannelType: pulumi.String("MockChannel"),
 * 			Credentials: pulumi.StringMap{
 * 				"AppId":  pulumi.String("exampleApp"),
 * 				"AppKey": pulumi.String("exampleAppKey"),
 * 			},
 * 			ResourceGroupName: pulumi.String("ExampleRg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.engagementfabric.Channel;
 * import com.pulumi.azurenative.engagementfabric.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .accountName("ExampleAccount")
 *             .channelFunctions(
 *                 "MockFunction1",
 *                 "MockFunction2")
 *             .channelName("ExampleChannel")
 *             .channelType("MockChannel")
 *             .credentials(Map.ofEntries(
 *                 Map.entry("AppId", "exampleApp"),
 *                 Map.entry("AppKey", "exampleAppKey")
 *             ))
 *             .resourceGroupName("ExampleRg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:engagementfabric:Channel ExampleChannel /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EngagementFabric/Accounts/{accountName}/Channels/{channelName}
 * ```
 * @property accountName Account Name
 * @property channelFunctions The functions to be enabled for the channel
 * @property channelName Channel Name
 * @property channelType The channel type
 * @property credentials The channel credentials
 * @property resourceGroupName Resource Group Name
 */
public data class ChannelArgs(
    public val accountName: Output<String>? = null,
    public val channelFunctions: Output<List<String>>? = null,
    public val channelName: Output<String>? = null,
    public val channelType: Output<String>? = null,
    public val credentials: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.engagementfabric.ChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.engagementfabric.ChannelArgs =
        com.pulumi.azurenative.engagementfabric.ChannelArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .channelFunctions(channelFunctions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .channelName(channelName?.applyValue({ args0 -> args0 }))
            .channelType(channelType?.applyValue({ args0 -> args0 }))
            .credentials(
                credentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelArgs].
 */
@PulumiTagMarker
public class ChannelArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var channelFunctions: Output<List<String>>? = null

    private var channelName: Output<String>? = null

    private var channelType: Output<String>? = null

    private var credentials: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Account Name
     */
    @JvmName("rnvlslaglsbvmtse")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The functions to be enabled for the channel
     */
    @JvmName("udwmccevjtqxyqdd")
    public suspend fun channelFunctions(`value`: Output<List<String>>) {
        this.channelFunctions = value
    }

    @JvmName("iprkwaubhchgnmyl")
    public suspend fun channelFunctions(vararg values: Output<String>) {
        this.channelFunctions = Output.all(values.asList())
    }

    /**
     * @param values The functions to be enabled for the channel
     */
    @JvmName("jwmmgtafifewfmde")
    public suspend fun channelFunctions(values: List<Output<String>>) {
        this.channelFunctions = Output.all(values)
    }

    /**
     * @param value Channel Name
     */
    @JvmName("crlbyoxcuuwfgauo")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value The channel type
     */
    @JvmName("celqtleqqopbgfuy")
    public suspend fun channelType(`value`: Output<String>) {
        this.channelType = value
    }

    /**
     * @param value The channel credentials
     */
    @JvmName("nfpnwtxyvmqwwdru")
    public suspend fun credentials(`value`: Output<Map<String, String>>) {
        this.credentials = value
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("nmrfcxowjhpfxuhr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Account Name
     */
    @JvmName("tjyoswqekxwjsfjp")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The functions to be enabled for the channel
     */
    @JvmName("dryvdxidpmsolmqt")
    public suspend fun channelFunctions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelFunctions = mapped
    }

    /**
     * @param values The functions to be enabled for the channel
     */
    @JvmName("ayanvjxfowrlpuil")
    public suspend fun channelFunctions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelFunctions = mapped
    }

    /**
     * @param value Channel Name
     */
    @JvmName("ttkeyixnxnkwltsk")
    public suspend fun channelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value The channel type
     */
    @JvmName("bltdvcgfkqomvfwk")
    public suspend fun channelType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelType = mapped
    }

    /**
     * @param value The channel credentials
     */
    @JvmName("oftyrduklaoekbbh")
    public suspend fun credentials(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param values The channel credentials
     */
    @JvmName("kvlugyoabsoxhalt")
    public fun credentials(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("vmkbfymkelfqgrlr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ChannelArgs = ChannelArgs(
        accountName = accountName,
        channelFunctions = channelFunctions,
        channelName = channelName,
        channelType = channelType,
        credentials = credentials,
        resourceGroupName = resourceGroupName,
    )
}
