@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin

import com.pulumi.azurenative.engagementfabric.EngagementfabricFunctions.getAccountPlain
import com.pulumi.azurenative.engagementfabric.EngagementfabricFunctions.getChannelPlain
import com.pulumi.azurenative.engagementfabric.EngagementfabricFunctions.listAccountChannelTypesPlain
import com.pulumi.azurenative.engagementfabric.EngagementfabricFunctions.listAccountKeysPlain
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.GetChannelPlainArgs
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.GetChannelPlainArgsBuilder
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.ListAccountChannelTypesPlainArgs
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.ListAccountChannelTypesPlainArgsBuilder
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.ListAccountKeysPlainArgs
import com.pulumi.azurenative.engagementfabric.kotlin.inputs.ListAccountKeysPlainArgsBuilder
import com.pulumi.azurenative.engagementfabric.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.engagementfabric.kotlin.outputs.GetChannelResult
import com.pulumi.azurenative.engagementfabric.kotlin.outputs.ListAccountChannelTypesResult
import com.pulumi.azurenative.engagementfabric.kotlin.outputs.ListAccountKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.engagementfabric.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.engagementfabric.kotlin.outputs.GetChannelResult.Companion.toKotlin as getChannelResultToKotlin
import com.pulumi.azurenative.engagementfabric.kotlin.outputs.ListAccountChannelTypesResult.Companion.toKotlin as listAccountChannelTypesResultToKotlin
import com.pulumi.azurenative.engagementfabric.kotlin.outputs.ListAccountKeysResult.Companion.toKotlin as listAccountKeysResultToKotlin

public object EngagementfabricFunctions {
    /**
     * The EngagementFabric account
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return The EngagementFabric account
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName Account Name
     * @param resourceGroupName Resource Group Name
     * @return The EngagementFabric account
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;engagementfabric&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return The EngagementFabric account
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit): GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * The EngagementFabric channel
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return The EngagementFabric channel
     */
    public suspend fun getChannel(argument: GetChannelPlainArgs): GetChannelResult =
        getChannelResultToKotlin(getChannelPlain(argument.toJava()).await())

    /**
     * @see [getChannel].
     * @param accountName Account Name
     * @param channelName Channel Name
     * @param resourceGroupName Resource Group Name
     * @return The EngagementFabric channel
     */
    public suspend fun getChannel(
        accountName: String,
        channelName: String,
        resourceGroupName: String,
    ): GetChannelResult {
        val argument = GetChannelPlainArgs(
            accountName = accountName,
            channelName = channelName,
            resourceGroupName = resourceGroupName,
        )
        return getChannelResultToKotlin(getChannelPlain(argument.toJava()).await())
    }

    /**
     * @see [getChannel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;engagementfabric&#46;kotlin&#46;inputs&#46;GetChannelPlainArgs].
     * @return The EngagementFabric channel
     */
    public suspend fun getChannel(argument: suspend GetChannelPlainArgsBuilder.() -> Unit): GetChannelResult {
        val builder = GetChannelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChannelResultToKotlin(getChannelPlain(builtArgument.toJava()).await())
    }

    /**
     * List of the EngagementFabric channel descriptions
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return List of the EngagementFabric channel descriptions
     */
    public suspend fun listAccountChannelTypes(argument: ListAccountChannelTypesPlainArgs): ListAccountChannelTypesResult =
        listAccountChannelTypesResultToKotlin(listAccountChannelTypesPlain(argument.toJava()).await())

    /**
     * @see [listAccountChannelTypes].
     * @param accountName Account Name
     * @param resourceGroupName Resource Group Name
     * @return List of the EngagementFabric channel descriptions
     */
    public suspend fun listAccountChannelTypes(accountName: String, resourceGroupName: String): ListAccountChannelTypesResult {
        val argument = ListAccountChannelTypesPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return listAccountChannelTypesResultToKotlin(listAccountChannelTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccountChannelTypes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;engagementfabric&#46;kotlin&#46;inputs&#46;ListAccountChannelTypesPlainArgs].
     * @return List of the EngagementFabric channel descriptions
     */
    public suspend fun listAccountChannelTypes(argument: suspend ListAccountChannelTypesPlainArgsBuilder.() -> Unit): ListAccountChannelTypesResult {
        val builder = ListAccountChannelTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccountChannelTypesResultToKotlin(listAccountChannelTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * The list of the EngagementFabric account keys
     * Azure REST API version: 2018-09-01-preview.
     * @param argument null
     * @return The list of the EngagementFabric account keys
     */
    public suspend fun listAccountKeys(argument: ListAccountKeysPlainArgs): ListAccountKeysResult =
        listAccountKeysResultToKotlin(listAccountKeysPlain(argument.toJava()).await())

    /**
     * @see [listAccountKeys].
     * @param accountName Account Name
     * @param resourceGroupName Resource Group Name
     * @return The list of the EngagementFabric account keys
     */
    public suspend fun listAccountKeys(accountName: String, resourceGroupName: String): ListAccountKeysResult {
        val argument = ListAccountKeysPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return listAccountKeysResultToKotlin(listAccountKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccountKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;engagementfabric&#46;kotlin&#46;inputs&#46;ListAccountKeysPlainArgs].
     * @return The list of the EngagementFabric account keys
     */
    public suspend fun listAccountKeys(argument: suspend ListAccountKeysPlainArgsBuilder.() -> Unit): ListAccountKeysResult {
        val builder = ListAccountKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccountKeysResultToKotlin(listAccountKeysPlain(builtArgument.toJava()).await())
    }
}
