@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * EngagementFabric channel description
 * @property channelDescription Text description for the channel
 * @property channelFunctions All the available functions for the channel
 * @property channelType Channel type
 */
public data class ChannelTypeDescriptionResponse(
    public val channelDescription: String? = null,
    public val channelFunctions: List<String>? = null,
    public val channelType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.engagementfabric.outputs.ChannelTypeDescriptionResponse): ChannelTypeDescriptionResponse = ChannelTypeDescriptionResponse(
            channelDescription = javaType.channelDescription().map({ args0 -> args0 }).orElse(null),
            channelFunctions = javaType.channelFunctions().map({ args0 -> args0 }),
            channelType = javaType.channelType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
