@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The EngagementFabric channel
 * @property channelFunctions The functions to be enabled for the channel
 * @property channelType The channel type
 * @property credentials The channel credentials
 * @property id The ID of the resource
 * @property name The name of the resource
 * @property type The fully qualified type of the resource
 */
public data class GetChannelResult(
    public val channelFunctions: List<String>? = null,
    public val channelType: String,
    public val credentials: Map<String, String>? = null,
    public val id: String,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.engagementfabric.outputs.GetChannelResult): GetChannelResult = GetChannelResult(
            channelFunctions = javaType.channelFunctions().map({ args0 -> args0 }),
            channelType = javaType.channelType(),
            credentials = javaType.credentials().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
