@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.PartnerTopicInfoResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PartnerTopicInfoResponse.Companion.toKotlin as partnerTopicInfoResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Channel].
 */
@PulumiTagMarker
public class ChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChannelArgs = ChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChannelArgsBuilder.() -> Unit) {
        val builder = ChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Channel {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.Channel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Channel(builtJavaResource)
    }
}

/**
 * Channel info.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### Channels_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var channel = new AzureNative.EventGrid.Channel("channel", new()
 *     {
 *         ChannelName = "exampleChannelName1",
 *         ChannelType = AzureNative.EventGrid.ChannelType.PartnerTopic,
 *         ExpirationTimeIfNotActivatedUtc = "2021-10-21T22:50:25.410433Z",
 *         MessageForActivation = "Example message to approver",
 *         PartnerNamespaceName = "examplePartnerNamespaceName1",
 *         PartnerTopicInfo = new AzureNative.EventGrid.Inputs.PartnerTopicInfoArgs
 *         {
 *             AzureSubscriptionId = "5b4b650e-28b9-4790-b3ab-ddbd88d727c4",
 *             Name = "examplePartnerTopic1",
 *             ResourceGroupName = "examplerg2",
 *             Source = "ContosoCorp.Accounts.User1",
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewChannel(ctx, "channel", &eventgrid.ChannelArgs{
 * 			ChannelName:                     pulumi.String("exampleChannelName1"),
 * 			ChannelType:                     pulumi.String(eventgrid.ChannelTypePartnerTopic),
 * 			ExpirationTimeIfNotActivatedUtc: pulumi.String("2021-10-21T22:50:25.410433Z"),
 * 			MessageForActivation:            pulumi.String("Example message to approver"),
 * 			PartnerNamespaceName:            pulumi.String("examplePartnerNamespaceName1"),
 * 			PartnerTopicInfo: &eventgrid.PartnerTopicInfoArgs{
 * 				AzureSubscriptionId: pulumi.String("5b4b650e-28b9-4790-b3ab-ddbd88d727c4"),
 * 				Name:                pulumi.String("examplePartnerTopic1"),
 * 				ResourceGroupName:   pulumi.String("examplerg2"),
 * 				Source:              pulumi.String("ContosoCorp.Accounts.User1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Channel;
 * import com.pulumi.azurenative.eventgrid.ChannelArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.PartnerTopicInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var channel = new Channel("channel", ChannelArgs.builder()
 *             .channelName("exampleChannelName1")
 *             .channelType("PartnerTopic")
 *             .expirationTimeIfNotActivatedUtc("2021-10-21T22:50:25.410433Z")
 *             .messageForActivation("Example message to approver")
 *             .partnerNamespaceName("examplePartnerNamespaceName1")
 *             .partnerTopicInfo(PartnerTopicInfoArgs.builder()
 *                 .azureSubscriptionId("5b4b650e-28b9-4790-b3ab-ddbd88d727c4")
 *                 .name("examplePartnerTopic1")
 *                 .resourceGroupName("examplerg2")
 *                 .source("ContosoCorp.Accounts.User1")
 *                 .build())
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Channel exampleChannelName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerNamespaces/{partnerNamespaceName}/channels/{channelName}
 * ```
 */
public class Channel internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.Channel,
) : KotlinCustomResource(javaResource, ChannelMapper) {
    /**
     * The type of the event channel which represents the direction flow of events.
     */
    public val channelType: Output<String>?
        get() = javaResource.channelType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Expiration time of the channel. If this timer expires while the corresponding partner topic is never activated,
     * the channel and corresponding partner topic are deleted.
     */
    public val expirationTimeIfNotActivatedUtc: Output<String>?
        get() = javaResource.expirationTimeIfNotActivatedUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Context or helpful message that can be used during the approval process by the subscriber.
     */
    public val messageForActivation: Output<String>?
        get() = javaResource.messageForActivation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource corresponding to the channel.
     */
    public val partnerTopicInfo: Output<PartnerTopicInfoResponse>?
        get() = javaResource.partnerTopicInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> partnerTopicInfoResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning state of the channel.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The readiness state of the corresponding partner topic.
     */
    public val readinessState: Output<String>?
        get() = javaResource.readinessState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to Channel resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ChannelMapper : ResourceMapper<Channel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.Channel::class == javaResource::class

    override fun map(javaResource: Resource): Channel = Channel(
        javaResource as
            com.pulumi.azurenative.eventgrid.Channel,
    )
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Channel].
 */
public suspend fun channel(name: String, block: suspend ChannelResourceBuilder.() -> Unit): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun channel(name: String): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
