@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.ClientArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.ClientState
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ClientAuthenticationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ClientAuthenticationArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ClientCertificateAuthenticationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ClientCertificateAuthenticationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Client resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### Clients_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var client = new AzureNative.EventGrid.Client("client", new()
 *     {
 *         Attributes = new Dictionary<string, object?>
 *         {
 *             ["deviceTypes"] = new[]
 *             {
 *                 "Fan",
 *                 "Light",
 *                 "AC",
 *             },
 *             ["floor"] = 3,
 *             ["room"] = "345",
 *         },
 *         ClientCertificateAuthentication = new AzureNative.EventGrid.Inputs.ClientCertificateAuthenticationArgs
 *         {
 *             ValidationScheme = AzureNative.EventGrid.ClientCertificateValidationScheme.SubjectMatchesAuthenticationName,
 *         },
 *         ClientName = "exampleClientName1",
 *         Description = "This is a test client",
 *         NamespaceName = "exampleNamespaceName1",
 *         ResourceGroupName = "examplerg",
 *         State = AzureNative.EventGrid.ClientState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewClient(ctx, "client", &eventgrid.ClientArgs{
 * 			Attributes: pulumi.Any(map[string]interface{}{
 * 				"deviceTypes": []string{
 * 					"Fan",
 * 					"Light",
 * 					"AC",
 * 				},
 * 				"floor": 3,
 * 				"room":  "345",
 * 			}),
 * 			ClientCertificateAuthentication: &eventgrid.ClientCertificateAuthenticationArgs{
 * 				ValidationScheme: pulumi.String(eventgrid.ClientCertificateValidationSchemeSubjectMatchesAuthenticationName),
 * 			},
 * 			ClientName:        pulumi.String("exampleClientName1"),
 * 			Description:       pulumi.String("This is a test client"),
 * 			NamespaceName:     pulumi.String("exampleNamespaceName1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			State:             pulumi.String(eventgrid.ClientStateEnabled),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Client;
 * import com.pulumi.azurenative.eventgrid.ClientArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.ClientCertificateAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var client = new Client("client", ClientArgs.builder()
 *             .attributes(Map.ofEntries(
 *                 Map.entry("deviceTypes",
 *                     "Fan",
 *                     "Light",
 *                     "AC"),
 *                 Map.entry("floor", 3),
 *                 Map.entry("room", "345")
 *             ))
 *             .clientCertificateAuthentication(ClientCertificateAuthenticationArgs.builder()
 *                 .validationScheme("SubjectMatchesAuthenticationName")
 *                 .build())
 *             .clientName("exampleClientName1")
 *             .description("This is a test client")
 *             .namespaceName("exampleNamespaceName1")
 *             .resourceGroupName("examplerg")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Client exampleClientName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/clients/{clientName}
 * ```
 * @property attributes Attributes for the client. Supported values are int, bool, string, string[].
 * Example:
 * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }
 * @property authentication Authentication information for the client.
 * @property authenticationName The name presented by the client for authentication. The default value is the name of the resource.
 * @property clientCertificateAuthentication The client certificate authentication information.
 * @property clientName The client name.
 * @property description Description for the Client resource.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property state Indicates if the client is enabled or not. Default value is Enabled.
 */
public data class ClientArgs(
    public val attributes: Output<Any>? = null,
    public val authentication: Output<ClientAuthenticationArgs>? = null,
    public val authenticationName: Output<String>? = null,
    public val clientCertificateAuthentication: Output<ClientCertificateAuthenticationArgs>? = null,
    public val clientName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val state: Output<Either<String, ClientState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.ClientArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.ClientArgs =
        com.pulumi.azurenative.eventgrid.ClientArgs.builder()
            .attributes(attributes?.applyValue({ args0 -> args0 }))
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .authenticationName(authenticationName?.applyValue({ args0 -> args0 }))
            .clientCertificateAuthentication(
                clientCertificateAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .clientName(clientName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClientArgs].
 */
@PulumiTagMarker
public class ClientArgsBuilder internal constructor() {
    private var attributes: Output<Any>? = null

    private var authentication: Output<ClientAuthenticationArgs>? = null

    private var authenticationName: Output<String>? = null

    private var clientCertificateAuthentication: Output<ClientCertificateAuthenticationArgs>? = null

    private var clientName: Output<String>? = null

    private var description: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var state: Output<Either<String, ClientState>>? = null

    /**
     * @param value Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }
     */
    @JvmName("crsqaiqlibhngcta")
    public suspend fun attributes(`value`: Output<Any>) {
        this.attributes = value
    }

    /**
     * @param value Authentication information for the client.
     */
    @JvmName("rkiacfflbicfqjmm")
    public suspend fun authentication(`value`: Output<ClientAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value The name presented by the client for authentication. The default value is the name of the resource.
     */
    @JvmName("ligcfpipdhxxjgqt")
    public suspend fun authenticationName(`value`: Output<String>) {
        this.authenticationName = value
    }

    /**
     * @param value The client certificate authentication information.
     */
    @JvmName("owayrmwlltqgindd")
    public suspend fun clientCertificateAuthentication(`value`: Output<ClientCertificateAuthenticationArgs>) {
        this.clientCertificateAuthentication = value
    }

    /**
     * @param value The client name.
     */
    @JvmName("lnfmfjhebcckurik")
    public suspend fun clientName(`value`: Output<String>) {
        this.clientName = value
    }

    /**
     * @param value Description for the Client resource.
     */
    @JvmName("nwjgduqkxjliaxuf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("hylsoqgbluivihwy")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("gbwtupflkchrxsov")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Indicates if the client is enabled or not. Default value is Enabled.
     */
    @JvmName("excyshvgerheneei")
    public suspend fun state(`value`: Output<Either<String, ClientState>>) {
        this.state = value
    }

    /**
     * @param value Attributes for the client. Supported values are int, bool, string, string[].
     * Example:
     * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }
     */
    @JvmName("gxvtadleegqqswfu")
    public suspend fun attributes(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value Authentication information for the client.
     */
    @JvmName("qqthrduudvifdtid")
    public suspend fun authentication(`value`: ClientAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument Authentication information for the client.
     */
    @JvmName("deikgeugxgrdagbp")
    public suspend fun authentication(argument: suspend ClientAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ClientAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value The name presented by the client for authentication. The default value is the name of the resource.
     */
    @JvmName("hgycvqnfrjfroybl")
    public suspend fun authenticationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationName = mapped
    }

    /**
     * @param value The client certificate authentication information.
     */
    @JvmName("krfmguxgcedyeftk")
    public suspend fun clientCertificateAuthentication(`value`: ClientCertificateAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCertificateAuthentication = mapped
    }

    /**
     * @param argument The client certificate authentication information.
     */
    @JvmName("rtfnrmkvaeexcvph")
    public suspend fun clientCertificateAuthentication(argument: suspend ClientCertificateAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ClientCertificateAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientCertificateAuthentication = mapped
    }

    /**
     * @param value The client name.
     */
    @JvmName("kfkipxhfxletbuut")
    public suspend fun clientName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientName = mapped
    }

    /**
     * @param value Description for the Client resource.
     */
    @JvmName("lidyjtgvadxuqkfk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("mysoyopnbidjvcrb")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("safglsmibspnuqda")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Indicates if the client is enabled or not. Default value is Enabled.
     */
    @JvmName("mdeiwmpbculdrjlb")
    public suspend fun state(`value`: Either<String, ClientState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Indicates if the client is enabled or not. Default value is Enabled.
     */
    @JvmName("cnyviqqndpqqsyja")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClientState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Indicates if the client is enabled or not. Default value is Enabled.
     */
    @JvmName("trpageoxjgpmbpxu")
    public fun state(`value`: ClientState) {
        val toBeMapped = Either.ofRight<String, ClientState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ClientArgs = ClientArgs(
        attributes = attributes,
        authentication = authentication,
        authenticationName = authenticationName,
        clientCertificateAuthentication = clientCertificateAuthentication,
        clientName = clientName,
        description = description,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        state = state,
    )
}
