@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonInputSchemaMappingResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin as identityInfoResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.InboundIpRuleResponse.Companion.toKotlin as inboundIpRuleResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.JsonInputSchemaMappingResponse.Companion.toKotlin as jsonInputSchemaMappingResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * EventGrid Domain.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2020-04-01-preview, 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### Domains_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domain = new AzureNative.EventGrid.Domain("domain", new()
 *     {
 *         DomainName = "exampledomain1",
 *         InboundIpRules = new[]
 *         {
 *             new AzureNative.EventGrid.Inputs.InboundIpRuleArgs
 *             {
 *                 Action = AzureNative.EventGrid.IpActionType.Allow,
 *                 IpMask = "12.18.30.15",
 *             },
 *             new AzureNative.EventGrid.Inputs.InboundIpRuleArgs
 *             {
 *                 Action = AzureNative.EventGrid.IpActionType.Allow,
 *                 IpMask = "12.18.176.1",
 *             },
 *         },
 *         Location = "westus2",
 *         PublicNetworkAccess = AzureNative.EventGrid.PublicNetworkAccess.Enabled,
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewDomain(ctx, "domain", &eventgrid.DomainArgs{
 * 			DomainName: pulumi.String("exampledomain1"),
 * 			InboundIpRules: eventgrid.InboundIpRuleArray{
 * 				&eventgrid.InboundIpRuleArgs{
 * 					Action: pulumi.String(eventgrid.IpActionTypeAllow),
 * 					IpMask: pulumi.String("12.18.30.15"),
 * 				},
 * 				&eventgrid.InboundIpRuleArgs{
 * 					Action: pulumi.String(eventgrid.IpActionTypeAllow),
 * 					IpMask: pulumi.String("12.18.176.1"),
 * 				},
 * 			},
 * 			Location:            pulumi.String("westus2"),
 * 			PublicNetworkAccess: pulumi.String(eventgrid.PublicNetworkAccessEnabled),
 * 			ResourceGroupName:   pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Domain;
 * import com.pulumi.azurenative.eventgrid.DomainArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.InboundIpRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domain = new Domain("domain", DomainArgs.builder()
 *             .domainName("exampledomain1")
 *             .inboundIpRules(
 *                 InboundIpRuleArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("12.18.30.15")
 *                     .build(),
 *                 InboundIpRuleArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("12.18.176.1")
 *                     .build())
 *             .location("westus2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Domain exampledomain1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/domains/{domainName}
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * This Boolean is used to specify the creation mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
     * In this context, creation of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
     * When this property is null or set to true, Event Grid is responsible of automatically creating the domain topic when the first event subscription is
     * created at the scope of the domain topic. If this property is set to false, then creating the first event subscription will require creating a domain topic
     * by the user. The self-management mode can be used if the user wants full control of when the domain topic is created, while auto-managed mode provides the
     * flexibility to perform less operations and manage fewer resources by the user. Also, note that in auto-managed creation mode, user is allowed to create the
     * domain topic on demand if needed.
     */
    public val autoCreateTopicWithFirstSubscription: Output<Boolean>?
        get() = javaResource.autoCreateTopicWithFirstSubscription().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * This Boolean is used to specify the deletion mechanism for 'all' the Event Grid Domain Topics associated with this Event Grid Domain resource.
     * In this context, deletion of domain topic can be auto-managed (when true) or self-managed (when false). The default value for this property is true.
     * When this property is set to true, Event Grid is responsible of automatically deleting the domain topic when the last event subscription at the scope
     * of the domain topic is deleted. If this property is set to false, then the user needs to manually delete the domain topic when it is no longer needed
     * (e.g., when last event subscription is deleted and the resource needs to be cleaned up). The self-management mode can be used if the user wants full
     * control of when the domain topic needs to be deleted, while auto-managed mode provides the flexibility to perform less operations and manage fewer
     * resources by the user.
     */
    public val autoDeleteTopicWithLastSubscription: Output<Boolean>?
        get() = javaResource.autoDeleteTopicWithLastSubscription().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Data Residency Boundary of the resource.
     */
    public val dataResidencyBoundary: Output<String>?
        get() = javaResource.dataResidencyBoundary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the domain.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Endpoint for the Event Grid Domain Resource which is used for publishing the events.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Identity information for the Event Grid Domain resource.
     */
    public val identity: Output<IdentityInfoResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    public val inboundIpRules: Output<List<InboundIpRuleResponse>>?
        get() = javaResource.inboundIpRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        inboundIpRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * This determines the format that Event Grid should expect for incoming events published to the Event Grid Domain Resource.
     */
    public val inputSchema: Output<String>?
        get() = javaResource.inputSchema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information about the InputSchemaMapping which specified the info about mapping event payload.
     */
    public val inputSchemaMapping: Output<JsonInputSchemaMappingResponse>?
        get() = javaResource.inputSchemaMapping().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jsonInputSchemaMappingResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Metric resource id for the Event Grid Domain Resource.
     */
    public val metricResourceId: Output<String>
        get() = javaResource.metricResourceId().applyValue({ args0 -> args0 })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state of the Event Grid Domain Resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules" />
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to the Event Grid Domain resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.azurenative.eventgrid.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
