@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainTopic].
 */
@PulumiTagMarker
public class DomainTopicResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainTopicArgs = DomainTopicArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainTopicArgsBuilder.() -> Unit) {
        val builder = DomainTopicArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainTopic {
        val builtJavaResource = com.pulumi.azurenative.eventgrid.DomainTopic(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainTopic(builtJavaResource)
    }
}

/**
 * Domain Topic.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### DomainTopics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domainTopic = new AzureNative.EventGrid.DomainTopic("domainTopic", new()
 *     {
 *         DomainName = "exampledomain1",
 *         DomainTopicName = "exampledomaintopic1",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewDomainTopic(ctx, "domainTopic", &eventgrid.DomainTopicArgs{
 * 			DomainName:        pulumi.String("exampledomain1"),
 * 			DomainTopicName:   pulumi.String("exampledomaintopic1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.DomainTopic;
 * import com.pulumi.azurenative.eventgrid.DomainTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainTopic = new DomainTopic("domainTopic", DomainTopicArgs.builder()
 *             .domainName("exampledomain1")
 *             .domainTopicName("exampledomaintopic1")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:DomainTopic exampledomaintopic1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/domains/{domainName}/topics/{domainTopicName}
 * ```
 */
public class DomainTopic internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.DomainTopic,
) : KotlinCustomResource(javaResource, DomainTopicMapper) {
    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the domain topic.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to Domain Topic resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DomainTopicMapper : ResourceMapper<DomainTopic> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.DomainTopic::class == javaResource::class

    override fun map(javaResource: Resource): DomainTopic = DomainTopic(
        javaResource as
            com.pulumi.azurenative.eventgrid.DomainTopic,
    )
}

/**
 * @see [DomainTopic].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainTopic].
 */
public suspend fun domainTopic(name: String, block: suspend DomainTopicResourceBuilder.() -> Unit): DomainTopic {
    val builder = DomainTopicResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainTopic].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainTopic(name: String): DomainTopic {
    val builder = DomainTopicResourceBuilder()
    builder.name(name)
    return builder.build()
}
