@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.DomainTopicArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Domain Topic.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### DomainTopics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domainTopic = new AzureNative.EventGrid.DomainTopic("domainTopic", new()
 *     {
 *         DomainName = "exampledomain1",
 *         DomainTopicName = "exampledomaintopic1",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewDomainTopic(ctx, "domainTopic", &eventgrid.DomainTopicArgs{
 * 			DomainName:        pulumi.String("exampledomain1"),
 * 			DomainTopicName:   pulumi.String("exampledomaintopic1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.DomainTopic;
 * import com.pulumi.azurenative.eventgrid.DomainTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainTopic = new DomainTopic("domainTopic", DomainTopicArgs.builder()
 *             .domainName("exampledomain1")
 *             .domainTopicName("exampledomaintopic1")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:DomainTopic exampledomaintopic1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/domains/{domainName}/topics/{domainTopicName}
 * ```
 * @property domainName Name of the domain.
 * @property domainTopicName Name of the domain topic.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class DomainTopicArgs(
    public val domainName: Output<String>? = null,
    public val domainTopicName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.DomainTopicArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.DomainTopicArgs =
        com.pulumi.azurenative.eventgrid.DomainTopicArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainTopicName(domainTopicName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainTopicArgs].
 */
@PulumiTagMarker
public class DomainTopicArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var domainTopicName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the domain.
     */
    @JvmName("wqoqijaokgvornho")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Name of the domain topic.
     */
    @JvmName("bwwpgiypirhafgsc")
    public suspend fun domainTopicName(`value`: Output<String>) {
        this.domainTopicName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("rowvaptxeketwwyw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("qohauralqgoynant")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Name of the domain topic.
     */
    @JvmName("foacqkwsptfseyig")
    public suspend fun domainTopicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainTopicName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("nfofrubocjuybsuf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DomainTopicArgs = DomainTopicArgs(
        domainName = domainName,
        domainTopicName = domainTopicName,
        resourceGroupName = resourceGroupName,
    )
}
