@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscriptionArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.DeliverySchema
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeliveryConfigurationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeliveryConfigurationArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.FiltersConfigurationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.FiltersConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Event Subscription.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### NamespaceTopicEventSubscriptions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceTopicEventSubscription = new AzureNative.EventGrid.NamespaceTopicEventSubscription("namespaceTopicEventSubscription", new()
 *     {
 *         DeliveryConfiguration = new AzureNative.EventGrid.Inputs.DeliveryConfigurationArgs
 *         {
 *             DeliveryMode = AzureNative.EventGrid.DeliveryMode.Queue,
 *             Queue = new AzureNative.EventGrid.Inputs.QueueInfoArgs
 *             {
 *                 EventTimeToLive = "P1D",
 *                 MaxDeliveryCount = 4,
 *                 ReceiveLockDurationInSeconds = 60,
 *             },
 *         },
 *         EventDeliverySchema = AzureNative.EventGrid.DeliverySchema.CloudEventSchemaV1_0,
 *         EventSubscriptionName = "examplenamespacetopicEventSub2",
 *         NamespaceName = "examplenamespace2",
 *         ResourceGroupName = "examplerg",
 *         TopicName = "examplenamespacetopic2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewNamespaceTopicEventSubscription(ctx, "namespaceTopicEventSubscription", &eventgrid.NamespaceTopicEventSubscriptionArgs{
 * 			DeliveryConfiguration: &eventgrid.DeliveryConfigurationArgs{
 * 				DeliveryMode: pulumi.String(eventgrid.DeliveryModeQueue),
 * 				Queue: &eventgrid.QueueInfoArgs{
 * 					EventTimeToLive:              pulumi.String("P1D"),
 * 					MaxDeliveryCount:             pulumi.Int(4),
 * 					ReceiveLockDurationInSeconds: pulumi.Int(60),
 * 				},
 * 			},
 * 			EventDeliverySchema:   pulumi.String(eventgrid.DeliverySchema_CloudEventSchemaV1_0),
 * 			EventSubscriptionName: pulumi.String("examplenamespacetopicEventSub2"),
 * 			NamespaceName:         pulumi.String("examplenamespace2"),
 * 			ResourceGroupName:     pulumi.String("examplerg"),
 * 			TopicName:             pulumi.String("examplenamespacetopic2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscription;
 * import com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscriptionArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.DeliveryConfigurationArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.QueueInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceTopicEventSubscription = new NamespaceTopicEventSubscription("namespaceTopicEventSubscription", NamespaceTopicEventSubscriptionArgs.builder()
 *             .deliveryConfiguration(DeliveryConfigurationArgs.builder()
 *                 .deliveryMode("Queue")
 *                 .queue(QueueInfoArgs.builder()
 *                     .eventTimeToLive("P1D")
 *                     .maxDeliveryCount(4)
 *                     .receiveLockDurationInSeconds(60)
 *                     .build())
 *                 .build())
 *             .eventDeliverySchema("CloudEventSchemaV1_0")
 *             .eventSubscriptionName("examplenamespacetopicEventSub2")
 *             .namespaceName("examplenamespace2")
 *             .resourceGroupName("examplerg")
 *             .topicName("examplenamespacetopic2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:NamespaceTopicEventSubscription examplenamespacetopicEventSub2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}/eventSubscriptions/{eventSubscriptionName}
 * ```
 * @property deliveryConfiguration Information about the delivery configuration of the event subscription.
 * @property eventDeliverySchema The event delivery schema for the event subscription.
 * @property eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property filtersConfiguration Information about the filter for the event subscription.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicName Name of the namespace topic.
 */
public data class NamespaceTopicEventSubscriptionArgs(
    public val deliveryConfiguration: Output<DeliveryConfigurationArgs>? = null,
    public val eventDeliverySchema: Output<Either<String, DeliverySchema>>? = null,
    public val eventSubscriptionName: Output<String>? = null,
    public val filtersConfiguration: Output<FiltersConfigurationArgs>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscriptionArgs =
        com.pulumi.azurenative.eventgrid.NamespaceTopicEventSubscriptionArgs.builder()
            .deliveryConfiguration(
                deliveryConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .eventDeliverySchema(
                eventDeliverySchema?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .eventSubscriptionName(eventSubscriptionName?.applyValue({ args0 -> args0 }))
            .filtersConfiguration(
                filtersConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceTopicEventSubscriptionArgs].
 */
@PulumiTagMarker
public class NamespaceTopicEventSubscriptionArgsBuilder internal constructor() {
    private var deliveryConfiguration: Output<DeliveryConfigurationArgs>? = null

    private var eventDeliverySchema: Output<Either<String, DeliverySchema>>? = null

    private var eventSubscriptionName: Output<String>? = null

    private var filtersConfiguration: Output<FiltersConfigurationArgs>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value Information about the delivery configuration of the event subscription.
     */
    @JvmName("tudkdjrjxefdtkxo")
    public suspend fun deliveryConfiguration(`value`: Output<DeliveryConfigurationArgs>) {
        this.deliveryConfiguration = value
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("wknhutnlrviajjyh")
    public suspend fun eventDeliverySchema(`value`: Output<Either<String, DeliverySchema>>) {
        this.eventDeliverySchema = value
    }

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("bwadsphxsujgchuf")
    public suspend fun eventSubscriptionName(`value`: Output<String>) {
        this.eventSubscriptionName = value
    }

    /**
     * @param value Information about the filter for the event subscription.
     */
    @JvmName("oufqhdoqjlivwppo")
    public suspend fun filtersConfiguration(`value`: Output<FiltersConfigurationArgs>) {
        this.filtersConfiguration = value
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("dnnnybvxlgqwkucl")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("mfrcxkummwdordyw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the namespace topic.
     */
    @JvmName("fcxsfvhoufnawrxo")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value Information about the delivery configuration of the event subscription.
     */
    @JvmName("ggarvxetffnumqqe")
    public suspend fun deliveryConfiguration(`value`: DeliveryConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryConfiguration = mapped
    }

    /**
     * @param argument Information about the delivery configuration of the event subscription.
     */
    @JvmName("udhqfjuqykrwxdjb")
    public suspend fun deliveryConfiguration(argument: suspend DeliveryConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DeliveryConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryConfiguration = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("slvhxddctgpurrvj")
    public suspend fun eventDeliverySchema(`value`: Either<String, DeliverySchema>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("emhqoqvagdjfxryi")
    public fun eventDeliverySchema(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeliverySchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("ycfgecwajgugpnmr")
    public fun eventDeliverySchema(`value`: DeliverySchema) {
        val toBeMapped = Either.ofRight<String, DeliverySchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("ygltbjjydrxitkjg")
    public suspend fun eventSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value Information about the filter for the event subscription.
     */
    @JvmName("wojqttbdtaxcjprx")
    public suspend fun filtersConfiguration(`value`: FiltersConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filtersConfiguration = mapped
    }

    /**
     * @param argument Information about the filter for the event subscription.
     */
    @JvmName("bnotdtqsxrgjfjog")
    public suspend fun filtersConfiguration(argument: suspend FiltersConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FiltersConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filtersConfiguration = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("ltseahnkvxquyqwq")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("ajqpmvpenuplmpgk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the namespace topic.
     */
    @JvmName("gkiutnjkmnrleqde")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): NamespaceTopicEventSubscriptionArgs = NamespaceTopicEventSubscriptionArgs(
        deliveryConfiguration = deliveryConfiguration,
        eventDeliverySchema = eventDeliverySchema,
        eventSubscriptionName = eventSubscriptionName,
        filtersConfiguration = filtersConfiguration,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        topicName = topicName,
    )
}
