@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.PartnerAuthorizationResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.eventgrid.kotlin.outputs.PartnerAuthorizationResponse.Companion.toKotlin as partnerAuthorizationResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PartnerConfiguration].
 */
@PulumiTagMarker
public class PartnerConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartnerConfigurationArgs = PartnerConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartnerConfigurationArgsBuilder.() -> Unit) {
        val builder = PartnerConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PartnerConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.eventgrid.PartnerConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PartnerConfiguration(builtJavaResource)
    }
}

/**
 * Partner configuration information
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### PartnerConfigurations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerConfiguration = new AzureNative.EventGrid.PartnerConfiguration("partnerConfiguration", new()
 *     {
 *         PartnerAuthorization = new AzureNative.EventGrid.Inputs.PartnerAuthorizationArgs
 *         {
 *             AuthorizedPartnersList = new[]
 *             {
 *                 new AzureNative.EventGrid.Inputs.PartnerArgs
 *                 {
 *                     AuthorizationExpirationTimeInUtc = "2022-01-28T01:20:55.142Z",
 *                     PartnerName = "Contoso.Finance",
 *                     PartnerRegistrationImmutableId = "941892bc-f5d0-4d1c-8fb5-477570fc2b71",
 *                 },
 *                 new AzureNative.EventGrid.Inputs.PartnerArgs
 *                 {
 *                     AuthorizationExpirationTimeInUtc = "2022-02-20T01:00:00.142Z",
 *                     PartnerName = "fabrikam.HR",
 *                     PartnerRegistrationImmutableId = "5362bdb6-ce3e-4d0d-9a5b-3eb92c8aab38",
 *                 },
 *             },
 *             DefaultMaximumExpirationTimeInDays = 10,
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerConfiguration(ctx, "partnerConfiguration", &eventgrid.PartnerConfigurationArgs{
 * 			PartnerAuthorization: &eventgrid.PartnerAuthorizationArgs{
 * 				AuthorizedPartnersList: eventgrid.PartnerArray{
 * 					&eventgrid.PartnerArgs{
 * 						AuthorizationExpirationTimeInUtc: pulumi.String("2022-01-28T01:20:55.142Z"),
 * 						PartnerName:                      pulumi.String("Contoso.Finance"),
 * 						PartnerRegistrationImmutableId:   pulumi.String("941892bc-f5d0-4d1c-8fb5-477570fc2b71"),
 * 					},
 * 					&eventgrid.PartnerArgs{
 * 						AuthorizationExpirationTimeInUtc: pulumi.String("2022-02-20T01:00:00.142Z"),
 * 						PartnerName:                      pulumi.String("fabrikam.HR"),
 * 						PartnerRegistrationImmutableId:   pulumi.String("5362bdb6-ce3e-4d0d-9a5b-3eb92c8aab38"),
 * 					},
 * 				},
 * 				DefaultMaximumExpirationTimeInDays: pulumi.Int(10),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerConfiguration;
 * import com.pulumi.azurenative.eventgrid.PartnerConfigurationArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.PartnerAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerConfiguration = new PartnerConfiguration("partnerConfiguration", PartnerConfigurationArgs.builder()
 *             .partnerAuthorization(PartnerAuthorizationArgs.builder()
 *                 .authorizedPartnersList(
 *                     PartnerArgs.builder()
 *                         .authorizationExpirationTimeInUtc("2022-01-28T01:20:55.142Z")
 *                         .partnerName("Contoso.Finance")
 *                         .partnerRegistrationImmutableId("941892bc-f5d0-4d1c-8fb5-477570fc2b71")
 *                         .build(),
 *                     PartnerArgs.builder()
 *                         .authorizationExpirationTimeInUtc("2022-02-20T01:00:00.142Z")
 *                         .partnerName("fabrikam.HR")
 *                         .partnerRegistrationImmutableId("5362bdb6-ce3e-4d0d-9a5b-3eb92c8aab38")
 *                         .build())
 *                 .defaultMaximumExpirationTimeInDays(10)
 *                 .build())
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerConfigurations/default
 * ```
 */
public class PartnerConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.PartnerConfiguration,
) : KotlinCustomResource(javaResource, PartnerConfigurationMapper) {
    /**
     * Location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The details of authorized partners.
     */
    public val partnerAuthorization: Output<PartnerAuthorizationResponse>?
        get() = javaResource.partnerAuthorization().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> partnerAuthorizationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning state of the partner configuration.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to partner configuration resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PartnerConfigurationMapper : ResourceMapper<PartnerConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.PartnerConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): PartnerConfiguration = PartnerConfiguration(
        javaResource
            as com.pulumi.azurenative.eventgrid.PartnerConfiguration,
    )
}

/**
 * @see [PartnerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PartnerConfiguration].
 */
public suspend fun partnerConfiguration(
    name: String,
    block: suspend PartnerConfigurationResourceBuilder.() -> Unit,
): PartnerConfiguration {
    val builder = PartnerConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PartnerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partnerConfiguration(name: String): PartnerConfiguration {
    val builder = PartnerConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
