@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.PartnerRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about a partner registration.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2021-10-15-preview, 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### PartnerRegistrations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerRegistration = new AzureNative.EventGrid.PartnerRegistration("partnerRegistration", new()
 *     {
 *         Location = "global",
 *         PartnerRegistrationName = "examplePartnerRegistrationName1",
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "Value2" },
 *             { "key3", "Value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerRegistration(ctx, "partnerRegistration", &eventgrid.PartnerRegistrationArgs{
 * 			Location:                pulumi.String("global"),
 * 			PartnerRegistrationName: pulumi.String("examplePartnerRegistrationName1"),
 * 			ResourceGroupName:       pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("Value2"),
 * 				"key3": pulumi.String("Value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerRegistration;
 * import com.pulumi.azurenative.eventgrid.PartnerRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerRegistration = new PartnerRegistration("partnerRegistration", PartnerRegistrationArgs.builder()
 *             .location("global")
 *             .partnerRegistrationName("examplePartnerRegistrationName1")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "Value2"),
 *                 Map.entry("key3", "Value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerRegistration examplePartnerRegistrationName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}
 * ```
 * @property location Location of the resource.
 * @property partnerRegistrationImmutableId The immutableId of the corresponding partner registration.
 * Note: This property is marked for deprecation and is not supported in any future GA API version
 * @property partnerRegistrationName Name of the partner registration.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property tags Tags of the resource.
 */
public data class PartnerRegistrationArgs(
    public val location: Output<String>? = null,
    public val partnerRegistrationImmutableId: Output<String>? = null,
    public val partnerRegistrationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.PartnerRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.PartnerRegistrationArgs =
        com.pulumi.azurenative.eventgrid.PartnerRegistrationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .partnerRegistrationImmutableId(partnerRegistrationImmutableId?.applyValue({ args0 -> args0 }))
            .partnerRegistrationName(partnerRegistrationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PartnerRegistrationArgs].
 */
@PulumiTagMarker
public class PartnerRegistrationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var partnerRegistrationImmutableId: Output<String>? = null

    private var partnerRegistrationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Location of the resource.
     */
    @JvmName("sexoetoosewdpevi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The immutableId of the corresponding partner registration.
     * Note: This property is marked for deprecation and is not supported in any future GA API version
     */
    @JvmName("iocgnuchooushfdk")
    public suspend fun partnerRegistrationImmutableId(`value`: Output<String>) {
        this.partnerRegistrationImmutableId = value
    }

    /**
     * @param value Name of the partner registration.
     */
    @JvmName("mjdrcexgtoictsfu")
    public suspend fun partnerRegistrationName(`value`: Output<String>) {
        this.partnerRegistrationName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("nvrmrghuhlapcakb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("jjovhtddpwwpuxvs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("yneryvfjraxwdekf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The immutableId of the corresponding partner registration.
     * Note: This property is marked for deprecation and is not supported in any future GA API version
     */
    @JvmName("wulugdlimbmnjrfx")
    public suspend fun partnerRegistrationImmutableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerRegistrationImmutableId = mapped
    }

    /**
     * @param value Name of the partner registration.
     */
    @JvmName("rrhvavffathtewil")
    public suspend fun partnerRegistrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerRegistrationName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("oovgonaxrboquewn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("hipmxeyolyfbyfdt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("mvxlptlloifttode")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PartnerRegistrationArgs = PartnerRegistrationArgs(
        location = location,
        partnerRegistrationImmutableId = partnerRegistrationImmutableId,
        partnerRegistrationName = partnerRegistrationName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
