@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeadLetterWithResourceIdentityResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeliveryWithResourceIdentityResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.EventSubscriptionFilterResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.RetryPolicyResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.StorageBlobDeadLetterDestinationResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeadLetterWithResourceIdentityResponse.Companion.toKotlin as deadLetterWithResourceIdentityResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.DeliveryWithResourceIdentityResponse.Companion.toKotlin as deliveryWithResourceIdentityResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.EventSubscriptionFilterResponse.Companion.toKotlin as eventSubscriptionFilterResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.RetryPolicyResponse.Companion.toKotlin as retryPolicyResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.StorageBlobDeadLetterDestinationResponse.Companion.toKotlin as storageBlobDeadLetterDestinationResponseToKotlin
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PartnerTopicEventSubscription].
 */
@PulumiTagMarker
public class PartnerTopicEventSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartnerTopicEventSubscriptionArgs = PartnerTopicEventSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartnerTopicEventSubscriptionArgsBuilder.() -> Unit) {
        val builder = PartnerTopicEventSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PartnerTopicEventSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PartnerTopicEventSubscription(builtJavaResource)
    }
}

/**
 * Event Subscription
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### PartnerTopicEventSubscriptions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerTopicEventSubscription = new AzureNative.EventGrid.PartnerTopicEventSubscription("partnerTopicEventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "exampleEventSubscriptionName1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         PartnerTopicName = "examplePartnerTopic1",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerTopicEventSubscription(ctx, "partnerTopicEventSubscription", &eventgrid.PartnerTopicEventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("exampleEventSubscriptionName1"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			PartnerTopicName:  pulumi.String("examplePartnerTopic1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscription;
 * import com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscriptionArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerTopicEventSubscription = new PartnerTopicEventSubscription("partnerTopicEventSubscription", PartnerTopicEventSubscriptionArgs.builder()
 *             .destination(WebHookEventSubscriptionDestinationArgs.builder()
 *                 .endpointType("WebHook")
 *                 .endpointUrl("https://requestb.in/15ksip71")
 *                 .build())
 *             .eventSubscriptionName("exampleEventSubscriptionName1")
 *             .filter(EventSubscriptionFilterArgs.builder()
 *                 .isSubjectCaseSensitive(false)
 *                 .subjectBeginsWith("ExamplePrefix")
 *                 .subjectEndsWith("ExampleSuffix")
 *                 .build())
 *             .partnerTopicName("examplePartnerTopic1")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerTopicEventSubscription exampleEventSubscriptionName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerTopics/{partnerTopicName}/eventSubscriptions/{eventSubscriptionName}
 * ```
 */
public class PartnerTopicEventSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscription,
) : KotlinCustomResource(javaResource, PartnerTopicEventSubscriptionMapper) {
    /**
     * The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    public val deadLetterDestination: Output<StorageBlobDeadLetterDestinationResponse>?
        get() = javaResource.deadLetterDestination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    storageBlobDeadLetterDestinationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    public val deadLetterWithResourceIdentity: Output<DeadLetterWithResourceIdentityResponse>?
        get() = javaResource.deadLetterWithResourceIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deadLetterWithResourceIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    public val deliveryWithResourceIdentity: Output<DeliveryWithResourceIdentityResponse>?
        get() = javaResource.deliveryWithResourceIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deliveryWithResourceIdentityResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    public val destination: Output<Any>?
        get() = javaResource.destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The event delivery schema for the event subscription.
     */
    public val eventDeliverySchema: Output<String>?
        get() = javaResource.eventDeliverySchema().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Expiration time of the event subscription.
     */
    public val expirationTimeUtc: Output<String>?
        get() = javaResource.expirationTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information about the filter for the event subscription.
     */
    public val filter: Output<EventSubscriptionFilterResponse>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    eventSubscriptionFilterResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of user defined labels.
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the event subscription.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    public val retryPolicy: Output<RetryPolicyResponse>?
        get() = javaResource.retryPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    retryPolicyResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The system metadata relating to Event Subscription resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Name of the topic of the event subscription.
     */
    public val topic: Output<String>
        get() = javaResource.topic().applyValue({ args0 -> args0 })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PartnerTopicEventSubscriptionMapper : ResourceMapper<PartnerTopicEventSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscription::class == javaResource::class

    override fun map(javaResource: Resource): PartnerTopicEventSubscription =
        PartnerTopicEventSubscription(
            javaResource as
                com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscription,
        )
}

/**
 * @see [PartnerTopicEventSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PartnerTopicEventSubscription].
 */
public suspend fun partnerTopicEventSubscription(
    name: String,
    block: suspend PartnerTopicEventSubscriptionResourceBuilder.() -> Unit,
): PartnerTopicEventSubscription {
    val builder = PartnerTopicEventSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PartnerTopicEventSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partnerTopicEventSubscription(name: String): PartnerTopicEventSubscription {
    val builder = PartnerTopicEventSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
