@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscriptionArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.EventDeliverySchema
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeadLetterWithResourceIdentityArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeadLetterWithResourceIdentityArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeliveryWithResourceIdentityArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeliveryWithResourceIdentityArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.EventSubscriptionFilterArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.EventSubscriptionFilterArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.RetryPolicyArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.RetryPolicyArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.StorageBlobDeadLetterDestinationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.StorageBlobDeadLetterDestinationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Event Subscription
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### PartnerTopicEventSubscriptions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerTopicEventSubscription = new AzureNative.EventGrid.PartnerTopicEventSubscription("partnerTopicEventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "exampleEventSubscriptionName1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         PartnerTopicName = "examplePartnerTopic1",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerTopicEventSubscription(ctx, "partnerTopicEventSubscription", &eventgrid.PartnerTopicEventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("exampleEventSubscriptionName1"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			PartnerTopicName:  pulumi.String("examplePartnerTopic1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscription;
 * import com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscriptionArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerTopicEventSubscription = new PartnerTopicEventSubscription("partnerTopicEventSubscription", PartnerTopicEventSubscriptionArgs.builder()
 *             .destination(WebHookEventSubscriptionDestinationArgs.builder()
 *                 .endpointType("WebHook")
 *                 .endpointUrl("https://requestb.in/15ksip71")
 *                 .build())
 *             .eventSubscriptionName("exampleEventSubscriptionName1")
 *             .filter(EventSubscriptionFilterArgs.builder()
 *                 .isSubjectCaseSensitive(false)
 *                 .subjectBeginsWith("ExamplePrefix")
 *                 .subjectEndsWith("ExampleSuffix")
 *                 .build())
 *             .partnerTopicName("examplePartnerTopic1")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerTopicEventSubscription exampleEventSubscriptionName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerTopics/{partnerTopicName}/eventSubscriptions/{eventSubscriptionName}
 * ```
 * @property deadLetterDestination The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property deadLetterWithResourceIdentity The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property deliveryWithResourceIdentity Information about the destination where events have to be delivered for the event subscription.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property destination Information about the destination where events have to be delivered for the event subscription.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property eventDeliverySchema The event delivery schema for the event subscription.
 * @property eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property expirationTimeUtc Expiration time of the event subscription.
 * @property filter Information about the filter for the event subscription.
 * @property labels List of user defined labels.
 * @property partnerTopicName Name of the partner topic.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property retryPolicy The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
 */
public data class PartnerTopicEventSubscriptionArgs(
    public val deadLetterDestination: Output<StorageBlobDeadLetterDestinationArgs>? = null,
    public val deadLetterWithResourceIdentity: Output<DeadLetterWithResourceIdentityArgs>? = null,
    public val deliveryWithResourceIdentity: Output<DeliveryWithResourceIdentityArgs>? = null,
    public val destination: Output<Any>? = null,
    public val eventDeliverySchema: Output<Either<String, EventDeliverySchema>>? = null,
    public val eventSubscriptionName: Output<String>? = null,
    public val expirationTimeUtc: Output<String>? = null,
    public val filter: Output<EventSubscriptionFilterArgs>? = null,
    public val labels: Output<List<String>>? = null,
    public val partnerTopicName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retryPolicy: Output<RetryPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscriptionArgs =
        com.pulumi.azurenative.eventgrid.PartnerTopicEventSubscriptionArgs.builder()
            .deadLetterDestination(
                deadLetterDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deadLetterWithResourceIdentity(
                deadLetterWithResourceIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .deliveryWithResourceIdentity(
                deliveryWithResourceIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .destination(destination?.applyValue({ args0 -> args0 }))
            .eventDeliverySchema(
                eventDeliverySchema?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .eventSubscriptionName(eventSubscriptionName?.applyValue({ args0 -> args0 }))
            .expirationTimeUtc(expirationTimeUtc?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .partnerTopicName(partnerTopicName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PartnerTopicEventSubscriptionArgs].
 */
@PulumiTagMarker
public class PartnerTopicEventSubscriptionArgsBuilder internal constructor() {
    private var deadLetterDestination: Output<StorageBlobDeadLetterDestinationArgs>? = null

    private var deadLetterWithResourceIdentity: Output<DeadLetterWithResourceIdentityArgs>? = null

    private var deliveryWithResourceIdentity: Output<DeliveryWithResourceIdentityArgs>? = null

    private var destination: Output<Any>? = null

    private var eventDeliverySchema: Output<Either<String, EventDeliverySchema>>? = null

    private var eventSubscriptionName: Output<String>? = null

    private var expirationTimeUtc: Output<String>? = null

    private var filter: Output<EventSubscriptionFilterArgs>? = null

    private var labels: Output<List<String>>? = null

    private var partnerTopicName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retryPolicy: Output<RetryPolicyArgs>? = null

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("kcabvfstncykptup")
    public suspend fun deadLetterDestination(`value`: Output<StorageBlobDeadLetterDestinationArgs>) {
        this.deadLetterDestination = value
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("nugbmhmhcpxkpmbq")
    public suspend fun deadLetterWithResourceIdentity(`value`: Output<DeadLetterWithResourceIdentityArgs>) {
        this.deadLetterWithResourceIdentity = value
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("xrhqsxxvibdxjdaj")
    public suspend fun deliveryWithResourceIdentity(`value`: Output<DeliveryWithResourceIdentityArgs>) {
        this.deliveryWithResourceIdentity = value
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("sqrlihrplhxgadql")
    public suspend fun destination(`value`: Output<Any>) {
        this.destination = value
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("wdqpnhmjceltlpbe")
    public suspend fun eventDeliverySchema(`value`: Output<Either<String, EventDeliverySchema>>) {
        this.eventDeliverySchema = value
    }

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("bbqxixpmgbbocihv")
    public suspend fun eventSubscriptionName(`value`: Output<String>) {
        this.eventSubscriptionName = value
    }

    /**
     * @param value Expiration time of the event subscription.
     */
    @JvmName("suwwcfkfemefflvr")
    public suspend fun expirationTimeUtc(`value`: Output<String>) {
        this.expirationTimeUtc = value
    }

    /**
     * @param value Information about the filter for the event subscription.
     */
    @JvmName("tqmoksijulhxgouj")
    public suspend fun filter(`value`: Output<EventSubscriptionFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value List of user defined labels.
     */
    @JvmName("kfxmpvljsvokjlou")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("hwtqlojsvjbtfaal")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of user defined labels.
     */
    @JvmName("ukfaxyugpkpapbkk")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("ynrsybxxcteufyqh")
    public suspend fun partnerTopicName(`value`: Output<String>) {
        this.partnerTopicName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("dwnxvhviityqthas")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("pfhohvpiqalptnby")
    public suspend fun retryPolicy(`value`: Output<RetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("hyhnxpebxkhyhvpu")
    public suspend fun deadLetterDestination(`value`: StorageBlobDeadLetterDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterDestination = mapped
    }

    /**
     * @param argument The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("dugsxpaeoovouhgx")
    public suspend fun deadLetterDestination(argument: suspend StorageBlobDeadLetterDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageBlobDeadLetterDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deadLetterDestination = mapped
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("hlmmscfjuuosiqii")
    public suspend fun deadLetterWithResourceIdentity(`value`: DeadLetterWithResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterWithResourceIdentity = mapped
    }

    /**
     * @param argument The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("ialcrclqkarxcsow")
    public suspend fun deadLetterWithResourceIdentity(argument: suspend DeadLetterWithResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DeadLetterWithResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deadLetterWithResourceIdentity = mapped
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("aqnmmocukdyvwnpw")
    public suspend fun deliveryWithResourceIdentity(`value`: DeliveryWithResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryWithResourceIdentity = mapped
    }

    /**
     * @param argument Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("palceflcqqqxanmf")
    public suspend fun deliveryWithResourceIdentity(argument: suspend DeliveryWithResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DeliveryWithResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryWithResourceIdentity = mapped
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("sybujqdcjnnpnlim")
    public suspend fun destination(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("opcwyuviocvwohbb")
    public suspend fun eventDeliverySchema(`value`: Either<String, EventDeliverySchema>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("urpeytkdnxgdxxcr")
    public fun eventDeliverySchema(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventDeliverySchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("wawfcmdjhijrttnk")
    public fun eventDeliverySchema(`value`: EventDeliverySchema) {
        val toBeMapped = Either.ofRight<String, EventDeliverySchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("ophtsfiemdjqpeor")
    public suspend fun eventSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value Expiration time of the event subscription.
     */
    @JvmName("yrretfajusfcmeev")
    public suspend fun expirationTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationTimeUtc = mapped
    }

    /**
     * @param value Information about the filter for the event subscription.
     */
    @JvmName("pidmaflbyijdbrah")
    public suspend fun filter(`value`: EventSubscriptionFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Information about the filter for the event subscription.
     */
    @JvmName("csfdkputcwphefrg")
    public suspend fun filter(argument: suspend EventSubscriptionFilterArgsBuilder.() -> Unit) {
        val toBeMapped = EventSubscriptionFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value List of user defined labels.
     */
    @JvmName("sopwqpwwhefgcxrs")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values List of user defined labels.
     */
    @JvmName("rclvntfyjocnlcos")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("tcqkpbbuecnqlioh")
    public suspend fun partnerTopicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerTopicName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("wdqtorcyuyofhsnl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("uxpcghlyaiegured")
    public suspend fun retryPolicy(`value`: RetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("nhhqcbyhsiurncbd")
    public suspend fun retryPolicy(argument: suspend RetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    internal fun build(): PartnerTopicEventSubscriptionArgs = PartnerTopicEventSubscriptionArgs(
        deadLetterDestination = deadLetterDestination,
        deadLetterWithResourceIdentity = deadLetterWithResourceIdentity,
        deliveryWithResourceIdentity = deliveryWithResourceIdentity,
        destination = destination,
        eventDeliverySchema = eventDeliverySchema,
        eventSubscriptionName = eventSubscriptionName,
        expirationTimeUtc = expirationTimeUtc,
        filter = filter,
        labels = labels,
        partnerTopicName = partnerTopicName,
        resourceGroupName = resourceGroupName,
        retryPolicy = retryPolicy,
    )
}
