@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PermissionBinding].
 */
@PulumiTagMarker
public class PermissionBindingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PermissionBindingArgs = PermissionBindingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PermissionBindingArgsBuilder.() -> Unit) {
        val builder = PermissionBindingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PermissionBinding {
        val builtJavaResource =
            com.pulumi.azurenative.eventgrid.PermissionBinding(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PermissionBinding(builtJavaResource)
    }
}

/**
 * The Permission binding resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### PermissionBindings_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var permissionBinding = new AzureNative.EventGrid.PermissionBinding("permissionBinding", new()
 *     {
 *         ClientGroupName = "exampleClientGroupName1",
 *         NamespaceName = "exampleNamespaceName1",
 *         Permission = AzureNative.EventGrid.PermissionType.Publisher,
 *         PermissionBindingName = "examplePermissionBindingName1",
 *         ResourceGroupName = "examplerg",
 *         TopicSpaceName = "exampleTopicSpaceName1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPermissionBinding(ctx, "permissionBinding", &eventgrid.PermissionBindingArgs{
 * 			ClientGroupName:       pulumi.String("exampleClientGroupName1"),
 * 			NamespaceName:         pulumi.String("exampleNamespaceName1"),
 * 			Permission:            pulumi.String(eventgrid.PermissionTypePublisher),
 * 			PermissionBindingName: pulumi.String("examplePermissionBindingName1"),
 * 			ResourceGroupName:     pulumi.String("examplerg"),
 * 			TopicSpaceName:        pulumi.String("exampleTopicSpaceName1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PermissionBinding;
 * import com.pulumi.azurenative.eventgrid.PermissionBindingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var permissionBinding = new PermissionBinding("permissionBinding", PermissionBindingArgs.builder()
 *             .clientGroupName("exampleClientGroupName1")
 *             .namespaceName("exampleNamespaceName1")
 *             .permission("Publisher")
 *             .permissionBindingName("examplePermissionBindingName1")
 *             .resourceGroupName("examplerg")
 *             .topicSpaceName("exampleTopicSpaceName1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PermissionBinding examplePermissionBindingName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/permissionBindings/{permissionBindingName}
 * ```
 */
public class PermissionBinding internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.PermissionBinding,
) : KotlinCustomResource(javaResource, PermissionBindingMapper) {
    /**
     * The name of the client group resource that the permission is bound to.
     * The client group needs to be a resource under the same namespace the permission binding is a part of.
     */
    public val clientGroupName: Output<String>?
        get() = javaResource.clientGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description for the Permission Binding resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The allowed permission.
     */
    public val permission: Output<String>?
        get() = javaResource.permission().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the PermissionBinding resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to the PermissionBinding resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of the Topic Space resource that the permission is bound to.
     * The Topic space needs to be a resource under the same namespace the permission binding is a part of.
     */
    public val topicSpaceName: Output<String>?
        get() = javaResource.topicSpaceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PermissionBindingMapper : ResourceMapper<PermissionBinding> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.PermissionBinding::class == javaResource::class

    override fun map(javaResource: Resource): PermissionBinding = PermissionBinding(
        javaResource as
            com.pulumi.azurenative.eventgrid.PermissionBinding,
    )
}

/**
 * @see [PermissionBinding].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PermissionBinding].
 */
public suspend fun permissionBinding(
    name: String,
    block: suspend PermissionBindingResourceBuilder.() -> Unit,
): PermissionBinding {
    val builder = PermissionBindingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PermissionBinding].
 * @param name The _unique_ name of the resulting resource.
 */
public fun permissionBinding(name: String): PermissionBinding {
    val builder = PermissionBindingResourceBuilder()
    builder.name(name)
    return builder.build()
}
