@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.SystemTopicArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * EventGrid System Topic.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### SystemTopics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var systemTopic = new AzureNative.EventGrid.SystemTopic("systemTopic", new()
 *     {
 *         Location = "westus2",
 *         ResourceGroupName = "examplerg",
 *         Source = "/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/azureeventgridrunnerrgcentraluseuap/providers/microsoft.storage/storageaccounts/pubstgrunnerb71cd29e",
 *         SystemTopicName = "exampleSystemTopic1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         TopicType = "microsoft.storage.storageaccounts",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewSystemTopic(ctx, "systemTopic", &eventgrid.SystemTopicArgs{
 * 			Location:          pulumi.String("westus2"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Source:            pulumi.String("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/azureeventgridrunnerrgcentraluseuap/providers/microsoft.storage/storageaccounts/pubstgrunnerb71cd29e"),
 * 			SystemTopicName:   pulumi.String("exampleSystemTopic1"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			TopicType: pulumi.String("microsoft.storage.storageaccounts"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.SystemTopic;
 * import com.pulumi.azurenative.eventgrid.SystemTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var systemTopic = new SystemTopic("systemTopic", SystemTopicArgs.builder()
 *             .location("westus2")
 *             .resourceGroupName("examplerg")
 *             .source("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/azureeventgridrunnerrgcentraluseuap/providers/microsoft.storage/storageaccounts/pubstgrunnerb71cd29e")
 *             .systemTopicName("exampleSystemTopic1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .topicType("microsoft.storage.storageaccounts")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:SystemTopic exampleSystemTopic2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/systemTopics/{systemTopicName}
 * ```
 * @property identity Identity information for the resource.
 * @property location Location of the resource.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property source Source for the system topic.
 * @property systemTopicName Name of the system topic.
 * @property tags Tags of the resource.
 * @property topicType TopicType for the system topic.
 */
public data class SystemTopicArgs(
    public val identity: Output<IdentityInfoArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<String>? = null,
    public val systemTopicName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topicType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.SystemTopicArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.SystemTopicArgs =
        com.pulumi.azurenative.eventgrid.SystemTopicArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .systemTopicName(systemTopicName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topicType(topicType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SystemTopicArgs].
 */
@PulumiTagMarker
public class SystemTopicArgsBuilder internal constructor() {
    private var identity: Output<IdentityInfoArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<String>? = null

    private var systemTopicName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topicType: Output<String>? = null

    /**
     * @param value Identity information for the resource.
     */
    @JvmName("ahjgqwmsmguxalrn")
    public suspend fun identity(`value`: Output<IdentityInfoArgs>) {
        this.identity = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("bmioyonnymdtejwf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("hdvvnwbwmpbriwmx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Source for the system topic.
     */
    @JvmName("xvipkfmfuffuncar")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Name of the system topic.
     */
    @JvmName("cciutsgpnphfkmuf")
    public suspend fun systemTopicName(`value`: Output<String>) {
        this.systemTopicName = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("tqmlxgrsweefpsuf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value TopicType for the system topic.
     */
    @JvmName("ukbnxnwrcckammov")
    public suspend fun topicType(`value`: Output<String>) {
        this.topicType = value
    }

    /**
     * @param value Identity information for the resource.
     */
    @JvmName("ehqjnhqscihclbrg")
    public suspend fun identity(`value`: IdentityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity information for the resource.
     */
    @JvmName("hlxigqkfabluakpi")
    public suspend fun identity(argument: suspend IdentityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("thpuiqcpokwdeblm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("iromdwmmbsxnocsw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Source for the system topic.
     */
    @JvmName("xnldvgrjcndrbbed")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Name of the system topic.
     */
    @JvmName("kalvuclnefoffdbt")
    public suspend fun systemTopicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemTopicName = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("twjailyhelmsyevl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("sibvfknouufsrlud")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value TopicType for the system topic.
     */
    @JvmName("mjxesuqiuvjdwjsy")
    public suspend fun topicType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicType = mapped
    }

    internal fun build(): SystemTopicArgs = SystemTopicArgs(
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        source = source,
        systemTopicName = systemTopicName,
        tags = tags,
        topicType = topicType,
    )
}
