@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.TopicArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.DataResidencyBoundary
import com.pulumi.azurenative.eventgrid.kotlin.enums.InputSchema
import com.pulumi.azurenative.eventgrid.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.InboundIpRuleArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.InboundIpRuleArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.JsonInputSchemaMappingArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.JsonInputSchemaMappingArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * EventGrid Topic
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2020-04-01-preview, 2023-06-01-preview, 2023-12-15-preview, 2024-06-01-preview.
 * ## Example Usage
 * ### Topics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topic = new AzureNative.EventGrid.Topic("topic", new()
 *     {
 *         InboundIpRules = new[]
 *         {
 *             new AzureNative.EventGrid.Inputs.InboundIpRuleArgs
 *             {
 *                 Action = AzureNative.EventGrid.IpActionType.Allow,
 *                 IpMask = "12.18.30.15",
 *             },
 *             new AzureNative.EventGrid.Inputs.InboundIpRuleArgs
 *             {
 *                 Action = AzureNative.EventGrid.IpActionType.Allow,
 *                 IpMask = "12.18.176.1",
 *             },
 *         },
 *         Location = "westus2",
 *         PublicNetworkAccess = AzureNative.EventGrid.PublicNetworkAccess.Enabled,
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         TopicName = "exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewTopic(ctx, "topic", &eventgrid.TopicArgs{
 * 			InboundIpRules: eventgrid.InboundIpRuleArray{
 * 				&eventgrid.InboundIpRuleArgs{
 * 					Action: pulumi.String(eventgrid.IpActionTypeAllow),
 * 					IpMask: pulumi.String("12.18.30.15"),
 * 				},
 * 				&eventgrid.InboundIpRuleArgs{
 * 					Action: pulumi.String(eventgrid.IpActionTypeAllow),
 * 					IpMask: pulumi.String("12.18.176.1"),
 * 				},
 * 			},
 * 			Location:            pulumi.String("westus2"),
 * 			PublicNetworkAccess: pulumi.String(eventgrid.PublicNetworkAccessEnabled),
 * 			ResourceGroupName:   pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			TopicName: pulumi.String("exampletopic1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Topic;
 * import com.pulumi.azurenative.eventgrid.TopicArgs;
 * import com.pulumi.azurenative.eventgrid.inputs.InboundIpRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topic = new Topic("topic", TopicArgs.builder()
 *             .inboundIpRules(
 *                 InboundIpRuleArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("12.18.30.15")
 *                     .build(),
 *                 InboundIpRuleArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("12.18.176.1")
 *                     .build())
 *             .location("westus2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .topicName("exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Topic exampletopic1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}
 * ```
 * @property dataResidencyBoundary Data Residency Boundary of the resource.
 * @property disableLocalAuth This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the topic.
 * @property identity Identity information for the resource.
 * @property inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
 * @property inputSchema This determines the format that Event Grid should expect for incoming events published to the topic.
 * @property inputSchemaMapping This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
 * @property location Location of the resource.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property tags Tags of the resource.
 * @property topicName Name of the topic.
 */
public data class TopicArgs(
    public val dataResidencyBoundary: Output<Either<String, DataResidencyBoundary>>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val identity: Output<IdentityInfoArgs>? = null,
    public val inboundIpRules: Output<List<InboundIpRuleArgs>>? = null,
    public val inputSchema: Output<Either<String, InputSchema>>? = null,
    public val inputSchemaMapping: Output<JsonInputSchemaMappingArgs>? = null,
    public val location: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.TopicArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.TopicArgs =
        com.pulumi.azurenative.eventgrid.TopicArgs.builder()
            .dataResidencyBoundary(
                dataResidencyBoundary?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inboundIpRules(
                inboundIpRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inputSchema(
                inputSchema?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .inputSchemaMapping(
                inputSchemaMapping?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicArgs].
 */
@PulumiTagMarker
public class TopicArgsBuilder internal constructor() {
    private var dataResidencyBoundary: Output<Either<String, DataResidencyBoundary>>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var identity: Output<IdentityInfoArgs>? = null

    private var inboundIpRules: Output<List<InboundIpRuleArgs>>? = null

    private var inputSchema: Output<Either<String, InputSchema>>? = null

    private var inputSchemaMapping: Output<JsonInputSchemaMappingArgs>? = null

    private var location: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value Data Residency Boundary of the resource.
     */
    @JvmName("qqkuadkydkcasnko")
    public suspend fun dataResidencyBoundary(`value`: Output<Either<String, DataResidencyBoundary>>) {
        this.dataResidencyBoundary = value
    }

    /**
     * @param value This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the topic.
     */
    @JvmName("yxereqbedvdqjsrw")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Identity information for the resource.
     */
    @JvmName("btihuasrlxifbwwa")
    public suspend fun identity(`value`: Output<IdentityInfoArgs>) {
        this.identity = value
    }

    /**
     * @param value This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("putmqdxlplwrenue")
    public suspend fun inboundIpRules(`value`: Output<List<InboundIpRuleArgs>>) {
        this.inboundIpRules = value
    }

    @JvmName("tgfyqhydxhjhcxmh")
    public suspend fun inboundIpRules(vararg values: Output<InboundIpRuleArgs>) {
        this.inboundIpRules = Output.all(values.asList())
    }

    /**
     * @param values This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("nbnuxqitlwmhtjot")
    public suspend fun inboundIpRules(values: List<Output<InboundIpRuleArgs>>) {
        this.inboundIpRules = Output.all(values)
    }

    /**
     * @param value This determines the format that Event Grid should expect for incoming events published to the topic.
     */
    @JvmName("dflnthyegiwbquhk")
    public suspend fun inputSchema(`value`: Output<Either<String, InputSchema>>) {
        this.inputSchema = value
    }

    /**
     * @param value This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
     */
    @JvmName("oeivqehiputroeev")
    public suspend fun inputSchemaMapping(`value`: Output<JsonInputSchemaMappingArgs>) {
        this.inputSchemaMapping = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("krhsipjlagyunwyd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />
     */
    @JvmName("botnmqcftlikbhsm")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("mngfmbmuofbdvdwn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("plkpokjrfxwqwowv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the topic.
     */
    @JvmName("bsrncpkitmaaoieq")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value Data Residency Boundary of the resource.
     */
    @JvmName("mhwpynkcgnbuwhny")
    public suspend fun dataResidencyBoundary(`value`: Either<String, DataResidencyBoundary>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataResidencyBoundary = mapped
    }

    /**
     * @param value Data Residency Boundary of the resource.
     */
    @JvmName("rfehjkwtgdhvfjuw")
    public fun dataResidencyBoundary(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataResidencyBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataResidencyBoundary = mapped
    }

    /**
     * @param value Data Residency Boundary of the resource.
     */
    @JvmName("ygdmvjfrwtqxxwtp")
    public fun dataResidencyBoundary(`value`: DataResidencyBoundary) {
        val toBeMapped = Either.ofRight<String, DataResidencyBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataResidencyBoundary = mapped
    }

    /**
     * @param value This boolean is used to enable or disable local auth. Default value is false. When the property is set to true, only AAD token will be used to authenticate if user is allowed to publish to the topic.
     */
    @JvmName("mwwdaeerpmxkipuw")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Identity information for the resource.
     */
    @JvmName("sxxrkgljjwmdlpyk")
    public suspend fun identity(`value`: IdentityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity information for the resource.
     */
    @JvmName("bihuvrmfbjcxjmbh")
    public suspend fun identity(argument: suspend IdentityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("ocvurlhofnpordrw")
    public suspend fun inboundIpRules(`value`: List<InboundIpRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("dlxmwlwhfsepclfy")
    public suspend fun inboundIpRules(argument: List<suspend InboundIpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundIpRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("vgacnwoarhwgpckg")
    public suspend fun inboundIpRules(vararg argument: suspend InboundIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InboundIpRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("trxncdvbxqvgyuya")
    public suspend fun inboundIpRules(argument: suspend InboundIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundIpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param values This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("kmtpjkplalrsgvnj")
    public suspend fun inboundIpRules(vararg values: InboundIpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundIpRules = mapped
    }

    /**
     * @param value This determines the format that Event Grid should expect for incoming events published to the topic.
     */
    @JvmName("gjjtlcwvaungyqbr")
    public suspend fun inputSchema(`value`: Either<String, InputSchema>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value This determines the format that Event Grid should expect for incoming events published to the topic.
     */
    @JvmName("sppfjmfnnmpygrnx")
    public fun inputSchema(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InputSchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value This determines the format that Event Grid should expect for incoming events published to the topic.
     */
    @JvmName("utosascliqnxxyqe")
    public fun inputSchema(`value`: InputSchema) {
        val toBeMapped = Either.ofRight<String, InputSchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
     */
    @JvmName("kmarsrackusfcvve")
    public suspend fun inputSchemaMapping(`value`: JsonInputSchemaMappingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSchemaMapping = mapped
    }

    /**
     * @param argument This enables publishing using custom event schemas. An InputSchemaMapping can be specified to map various properties of a source schema to various required properties of the EventGridEvent schema.
     */
    @JvmName("naijhdyvadgyxohr")
    public suspend fun inputSchemaMapping(argument: suspend JsonInputSchemaMappingArgsBuilder.() -> Unit) {
        val toBeMapped = JsonInputSchemaMappingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputSchemaMapping = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("ghjeaxhdopxmgild")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />
     */
    @JvmName("sbhvuwmjxtskfgok")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />
     */
    @JvmName("arjnninmksfdthyf")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />
     */
    @JvmName("yyauwxkfnsnkhjrw")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("xedpevkxkegfanps")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("aamwtxlcjhyrhesp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("udkgixbnfsbnppbl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the topic.
     */
    @JvmName("dydkuwbnydyrmltv")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): TopicArgs = TopicArgs(
        dataResidencyBoundary = dataResidencyBoundary,
        disableLocalAuth = disableLocalAuth,
        identity = identity,
        inboundIpRules = inboundIpRules,
        inputSchema = inputSchema,
        inputSchemaMapping = inputSchemaMapping,
        location = location,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        tags = tags,
        topicName = topicName,
    )
}
