@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules" />
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.eventgrid.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.eventgrid.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.PublicNetworkAccess): PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
