@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
 */
public enum class TlsVersion(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.TlsVersion,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.TlsVersion> {
    _1_0(com.pulumi.azurenative.eventgrid.enums.TlsVersion._1_0),
    _1_1(com.pulumi.azurenative.eventgrid.enums.TlsVersion._1_1),
    _1_2(com.pulumi.azurenative.eventgrid.enums.TlsVersion._1_2),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.TlsVersion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.TlsVersion): TlsVersion =
            TlsVersion.values().first { it.javaValue == javaType }
    }
}
