@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.BoolEqualsFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * BoolEquals Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'BoolEquals'.
 * @property value The boolean filter value.
 */
public data class BoolEqualsFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val `value`: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.BoolEqualsFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.BoolEqualsFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.BoolEqualsFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BoolEqualsFilterArgs].
 */
@PulumiTagMarker
public class BoolEqualsFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var `value`: Output<Boolean>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("khgwfcetnoljqmqq")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'BoolEquals'.
     */
    @JvmName("dyisdadumejlsbem")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The boolean filter value.
     */
    @JvmName("dgqqyrbjyaujnyds")
    public suspend fun `value`(`value`: Output<Boolean>) {
        this.`value` = value
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("svldjlqhkjhdydwi")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'BoolEquals'.
     */
    @JvmName("vvchivbvmdiytsin")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The boolean filter value.
     */
    @JvmName("yutbfomhkhoobluc")
    public suspend fun `value`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): BoolEqualsFilterArgs = BoolEqualsFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
        `value` = `value`,
    )
}
