@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.ClientAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Authentication properties for the client.
 * @property certificateSubject The CA certificate subject name used for authentication.
 * @property certificateThumbprint The self signed certificate's thumbprints data used for authentication.
 */
public data class ClientAuthenticationArgs(
    public val certificateSubject: Output<ClientCertificateSubjectDistinguishedNameArgs>? = null,
    public val certificateThumbprint: Output<ClientCertificateThumbprintArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.ClientAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.ClientAuthenticationArgs =
        com.pulumi.azurenative.eventgrid.inputs.ClientAuthenticationArgs.builder()
            .certificateSubject(
                certificateSubject?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .certificateThumbprint(
                certificateThumbprint?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ClientAuthenticationArgs].
 */
@PulumiTagMarker
public class ClientAuthenticationArgsBuilder internal constructor() {
    private var certificateSubject: Output<ClientCertificateSubjectDistinguishedNameArgs>? = null

    private var certificateThumbprint: Output<ClientCertificateThumbprintArgs>? = null

    /**
     * @param value The CA certificate subject name used for authentication.
     */
    @JvmName("ahanpeoivyxvayyq")
    public suspend fun certificateSubject(`value`: Output<ClientCertificateSubjectDistinguishedNameArgs>) {
        this.certificateSubject = value
    }

    /**
     * @param value The self signed certificate's thumbprints data used for authentication.
     */
    @JvmName("qxtjhrbwdlrmxglo")
    public suspend fun certificateThumbprint(`value`: Output<ClientCertificateThumbprintArgs>) {
        this.certificateThumbprint = value
    }

    /**
     * @param value The CA certificate subject name used for authentication.
     */
    @JvmName("pefgahulfpdtjiap")
    public suspend fun certificateSubject(`value`: ClientCertificateSubjectDistinguishedNameArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateSubject = mapped
    }

    /**
     * @param argument The CA certificate subject name used for authentication.
     */
    @JvmName("fdnuqsakgcilcmox")
    public suspend fun certificateSubject(argument: suspend ClientCertificateSubjectDistinguishedNameArgsBuilder.() -> Unit) {
        val toBeMapped = ClientCertificateSubjectDistinguishedNameArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.certificateSubject = mapped
    }

    /**
     * @param value The self signed certificate's thumbprints data used for authentication.
     */
    @JvmName("ytrirtwuvnfjuhwi")
    public suspend fun certificateThumbprint(`value`: ClientCertificateThumbprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateThumbprint = mapped
    }

    /**
     * @param argument The self signed certificate's thumbprints data used for authentication.
     */
    @JvmName("kufegvcwausmuxut")
    public suspend fun certificateThumbprint(argument: suspend ClientCertificateThumbprintArgsBuilder.() -> Unit) {
        val toBeMapped = ClientCertificateThumbprintArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.certificateThumbprint = mapped
    }

    internal fun build(): ClientAuthenticationArgs = ClientAuthenticationArgs(
        certificateSubject = certificateSubject,
        certificateThumbprint = certificateThumbprint,
    )
}
