@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionIdentityArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.EventSubscriptionIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The identity information with the event subscription.
 * @property type The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
 * @property userAssignedIdentity The user identity associated with the resource.
 */
public data class EventSubscriptionIdentityArgs(
    public val type: Output<Either<String, EventSubscriptionIdentityType>>? = null,
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionIdentityArgs =
        com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSubscriptionIdentityArgs].
 */
@PulumiTagMarker
public class EventSubscriptionIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, EventSubscriptionIdentityType>>? = null

    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
     */
    @JvmName("sjprsytdtaidsoqm")
    public suspend fun type(`value`: Output<Either<String, EventSubscriptionIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The user identity associated with the resource.
     */
    @JvmName("dmbiveymmlyyqglm")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
     */
    @JvmName("bhbevoxpaqwcksmr")
    public suspend fun type(`value`: Either<String, EventSubscriptionIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
     */
    @JvmName("qotsutysahyhgjar")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventSubscriptionIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
     */
    @JvmName("oyumnyvmcggljkes")
    public fun type(`value`: EventSubscriptionIdentityType) {
        val toBeMapped = Either.ofRight<String, EventSubscriptionIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user identity associated with the resource.
     */
    @JvmName("tqnombmmohauhgwm")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): EventSubscriptionIdentityArgs = EventSubscriptionIdentityArgs(
        type = type,
        userAssignedIdentity = userAssignedIdentity,
    )
}
