@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.FiltersConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Filters configuration for the Event Subscription.
 * @property filters An array of filters that are used for filtering event subscriptions.
 * @property includedEventTypes A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
 */
public data class FiltersConfigurationArgs(
    public val filters: Output<List<Any>>? = null,
    public val includedEventTypes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.FiltersConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.FiltersConfigurationArgs =
        com.pulumi.azurenative.eventgrid.inputs.FiltersConfigurationArgs.builder()
            .filters(filters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedEventTypes(
                includedEventTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [FiltersConfigurationArgs].
 */
@PulumiTagMarker
public class FiltersConfigurationArgsBuilder internal constructor() {
    private var filters: Output<List<Any>>? = null

    private var includedEventTypes: Output<List<String>>? = null

    /**
     * @param value An array of filters that are used for filtering event subscriptions.
     */
    @JvmName("kcbpknjniruxldvx")
    public suspend fun filters(`value`: Output<List<Any>>) {
        this.filters = value
    }

    @JvmName("ykvogvcoaqujafbc")
    public suspend fun filters(vararg values: Output<Any>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values An array of filters that are used for filtering event subscriptions.
     */
    @JvmName("ttjiititjiahpmth")
    public suspend fun filters(values: List<Output<Any>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     */
    @JvmName("faomsxeshofekwno")
    public suspend fun includedEventTypes(`value`: Output<List<String>>) {
        this.includedEventTypes = value
    }

    @JvmName("dkpkjqwlbtqnkgvc")
    public suspend fun includedEventTypes(vararg values: Output<String>) {
        this.includedEventTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     */
    @JvmName("lonjvtruoipdmflr")
    public suspend fun includedEventTypes(values: List<Output<String>>) {
        this.includedEventTypes = Output.all(values)
    }

    /**
     * @param value An array of filters that are used for filtering event subscriptions.
     */
    @JvmName("jybvtheorjjkekgs")
    public suspend fun filters(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param values An array of filters that are used for filtering event subscriptions.
     */
    @JvmName("pbbpqqsivebtpsnm")
    public suspend fun filters(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     */
    @JvmName("kgcgrvctxokrotnh")
    public suspend fun includedEventTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedEventTypes = mapped
    }

    /**
     * @param values A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     */
    @JvmName("ipmufueqwhrlcotj")
    public suspend fun includedEventTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedEventTypes = mapped
    }

    internal fun build(): FiltersConfigurationArgs = FiltersConfigurationArgs(
        filters = filters,
        includedEventTypes = includedEventTypes,
    )
}
