@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetChannelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property channelName Name of the channel.
 * @property partnerNamespaceName Name of the partner namespace.
 * @property resourceGroupName The name of the resource group within the partners subscription.
 */
public data class GetChannelPlainArgs(
    public val channelName: String,
    public val partnerNamespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetChannelPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetChannelPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetChannelPlainArgs.builder()
            .channelName(channelName.let({ args0 -> args0 }))
            .partnerNamespaceName(partnerNamespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetChannelPlainArgs].
 */
@PulumiTagMarker
public class GetChannelPlainArgsBuilder internal constructor() {
    private var channelName: String? = null

    private var partnerNamespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the channel.
     */
    @JvmName("kovorvblbmfwapre")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.channelName = mapped
    }

    /**
     * @param value Name of the partner namespace.
     */
    @JvmName("pmiovfilpwkrskhy")
    public suspend fun partnerNamespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerNamespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the partners subscription.
     */
    @JvmName("xbxytawhtaxdvrha")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetChannelPlainArgs = GetChannelPlainArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        partnerNamespaceName = partnerNamespaceName ?: throw
            PulumiNullFieldException("partnerNamespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
