@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetDomainTopicPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Name of the domain.
 * @property domainTopicName Name of the topic.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetDomainTopicPlainArgs(
    public val domainName: String,
    public val domainTopicName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetDomainTopicPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetDomainTopicPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetDomainTopicPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .domainTopicName(domainTopicName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainTopicPlainArgs].
 */
@PulumiTagMarker
public class GetDomainTopicPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var domainTopicName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the domain.
     */
    @JvmName("ymipwoyqfqmlahvo")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Name of the topic.
     */
    @JvmName("dlpjfpecdysapjmr")
    public suspend fun domainTopicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainTopicName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("kcebtjvrfnxmwrqc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDomainTopicPlainArgs = GetDomainTopicPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        domainTopicName = domainTopicName ?: throw PulumiNullFieldException("domainTopicName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
