@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPartnerDestinationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partnerDestinationName Name of the partner destination.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPartnerDestinationPlainArgs(
    public val partnerDestinationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPartnerDestinationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetPartnerDestinationPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerDestinationPlainArgs.builder()
            .partnerDestinationName(partnerDestinationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartnerDestinationPlainArgs].
 */
@PulumiTagMarker
public class GetPartnerDestinationPlainArgsBuilder internal constructor() {
    private var partnerDestinationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the partner destination.
     */
    @JvmName("vhcouplnfrrkccfs")
    public suspend fun partnerDestinationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerDestinationName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("tldsjpyxktdwkkqd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPartnerDestinationPlainArgs = GetPartnerDestinationPlainArgs(
        partnerDestinationName = partnerDestinationName ?: throw
            PulumiNullFieldException("partnerDestinationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
