@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partnerTopicName Name of the partner topic.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPartnerTopicPlainArgs(
    public val partnerTopicName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicPlainArgs.builder()
            .partnerTopicName(partnerTopicName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartnerTopicPlainArgs].
 */
@PulumiTagMarker
public class GetPartnerTopicPlainArgsBuilder internal constructor() {
    private var partnerTopicName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("diovkfmwutqnyuvg")
    public suspend fun partnerTopicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerTopicName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("kreocxfvhggvylgn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPartnerTopicPlainArgs = GetPartnerTopicPlainArgs(
        partnerTopicName = partnerTopicName ?: throw PulumiNullFieldException("partnerTopicName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
