@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.IsNotNullAdvancedFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IsNotNull Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'IsNotNull'.
 */
public data class IsNotNullAdvancedFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.IsNotNullAdvancedFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.IsNotNullAdvancedFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.IsNotNullAdvancedFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IsNotNullAdvancedFilterArgs].
 */
@PulumiTagMarker
public class IsNotNullAdvancedFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("mecxgffdxsnjfhjj")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'IsNotNull'.
     */
    @JvmName("efsaxpycbecbxvty")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("vepldaaqahqkxuve")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'IsNotNull'.
     */
    @JvmName("xvkxngquvppejucr")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    internal fun build(): IsNotNullAdvancedFilterArgs = IsNotNullAdvancedFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
    )
}
