@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.NumberGreaterThanFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * NumberGreaterThan Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'NumberGreaterThan'.
 * @property value The filter value.
 */
public data class NumberGreaterThanFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val `value`: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.NumberGreaterThanFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.NumberGreaterThanFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.NumberGreaterThanFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NumberGreaterThanFilterArgs].
 */
@PulumiTagMarker
public class NumberGreaterThanFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("ecwkikpmcrmsgbua")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberGreaterThan'.
     */
    @JvmName("jumuxsbcqintfmkt")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The filter value.
     */
    @JvmName("eiicofsuybxutjtc")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("gfwkwavasgyaygcs")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberGreaterThan'.
     */
    @JvmName("draumuyteqyqrkdh")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The filter value.
     */
    @JvmName("fuwrnctjbvhkpkrp")
    public suspend fun `value`(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): NumberGreaterThanFilterArgs = NumberGreaterThanFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
        `value` = `value`,
    )
}
