@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.StorageQueueEventSubscriptionDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the storage queue destination for an event subscription.
 * @property endpointType Type of the endpoint for the event subscription destination.
 * Expected value is 'StorageQueue'.
 * @property queueMessageTimeToLiveInSeconds Storage queue message time to live in seconds.
 * @property queueName The name of the Storage queue under a storage account that is the destination of an event subscription.
 * @property resourceId The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
 */
public data class StorageQueueEventSubscriptionDestinationArgs(
    public val endpointType: Output<String>,
    public val queueMessageTimeToLiveInSeconds: Output<Double>? = null,
    public val queueName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.StorageQueueEventSubscriptionDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.StorageQueueEventSubscriptionDestinationArgs =
        com.pulumi.azurenative.eventgrid.inputs.StorageQueueEventSubscriptionDestinationArgs.builder()
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .queueMessageTimeToLiveInSeconds(queueMessageTimeToLiveInSeconds?.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageQueueEventSubscriptionDestinationArgs].
 */
@PulumiTagMarker
public class StorageQueueEventSubscriptionDestinationArgsBuilder internal constructor() {
    private var endpointType: Output<String>? = null

    private var queueMessageTimeToLiveInSeconds: Output<Double>? = null

    private var queueName: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Type of the endpoint for the event subscription destination.
     * Expected value is 'StorageQueue'.
     */
    @JvmName("kxcuxciadmosfxuh")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value Storage queue message time to live in seconds.
     */
    @JvmName("uhfdupyghqlrcqgl")
    public suspend fun queueMessageTimeToLiveInSeconds(`value`: Output<Double>) {
        this.queueMessageTimeToLiveInSeconds = value
    }

    /**
     * @param value The name of the Storage queue under a storage account that is the destination of an event subscription.
     */
    @JvmName("pramhmhidmxckyja")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
     */
    @JvmName("okpaenjbjspwoiwk")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Type of the endpoint for the event subscription destination.
     * Expected value is 'StorageQueue'.
     */
    @JvmName("ewdncfoyvtdkxbxq")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Storage queue message time to live in seconds.
     */
    @JvmName("xxtidtpchbytjgel")
    public suspend fun queueMessageTimeToLiveInSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueMessageTimeToLiveInSeconds = mapped
    }

    /**
     * @param value The name of the Storage queue under a storage account that is the destination of an event subscription.
     */
    @JvmName("xvxyscduehhtrckw")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
     */
    @JvmName("rmfbdgndpacwwtge")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): StorageQueueEventSubscriptionDestinationArgs =
        StorageQueueEventSubscriptionDestinationArgs(
            endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
            queueMessageTimeToLiveInSeconds = queueMessageTimeToLiveInSeconds,
            queueName = queueName,
            resourceId = resourceId,
        )
}
