@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.StringNotBeginsWithAdvancedFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * StringNotBeginsWith Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'StringNotBeginsWith'.
 * @property values The set of filter values.
 */
public data class StringNotBeginsWithAdvancedFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val values: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.StringNotBeginsWithAdvancedFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.StringNotBeginsWithAdvancedFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.StringNotBeginsWithAdvancedFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [StringNotBeginsWithAdvancedFilterArgs].
 */
@PulumiTagMarker
public class StringNotBeginsWithAdvancedFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("qjepxulldgshpdig")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'StringNotBeginsWith'.
     */
    @JvmName("euxdfaxujvtqrwge")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("ypbvnswuujjyiaxr")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("gustrrfhupqrrsah")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("mekotpeeipvfelxa")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("taeuibdnpkaektvb")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'StringNotBeginsWith'.
     */
    @JvmName("ylfettdqvpulrkkj")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("qolqrgmvcgwdfndw")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("joenvjwruebyvlek")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): StringNotBeginsWithAdvancedFilterArgs =
        StringNotBeginsWithAdvancedFilterArgs(
            key = key,
            operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
            values = values,
        )
}
