@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.UserIdentityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The information about the user identity.
 * @property clientId The client id of user assigned identity.
 * @property principalId The principal id of user assigned identity.
 */
public data class UserIdentityPropertiesArgs(
    public val clientId: Output<String>? = null,
    public val principalId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.UserIdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.UserIdentityPropertiesArgs =
        com.pulumi.azurenative.eventgrid.inputs.UserIdentityPropertiesArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserIdentityPropertiesArgs].
 */
@PulumiTagMarker
public class UserIdentityPropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var principalId: Output<String>? = null

    /**
     * @param value The client id of user assigned identity.
     */
    @JvmName("dgewxrhbniovamhs")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The principal id of user assigned identity.
     */
    @JvmName("joqrpavithwnaeal")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The client id of user assigned identity.
     */
    @JvmName("krlgtbaubddieyle")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The principal id of user assigned identity.
     */
    @JvmName("dmlxosydcylrmjbb")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    internal fun build(): UserIdentityPropertiesArgs = UserIdentityPropertiesArgs(
        clientId = clientId,
        principalId = principalId,
    )
}
