@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Suppress

/**
 * The Authentication properties for the client.
 * @property certificateSubject The CA certificate subject name used for authentication.
 * @property certificateThumbprint The self signed certificate's thumbprints data used for authentication.
 */
public data class ClientAuthenticationResponse(
    public val certificateSubject: ClientCertificateSubjectDistinguishedNameResponse? = null,
    public val certificateThumbprint: ClientCertificateThumbprintResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ClientAuthenticationResponse): ClientAuthenticationResponse = ClientAuthenticationResponse(
            certificateSubject = javaType.certificateSubject().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientCertificateSubjectDistinguishedNameResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            certificateThumbprint = javaType.certificateThumbprint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientCertificateThumbprintResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
