@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The certificate authentication properties for the client.
 * @property allowedThumbprints The list of thumbprints that are allowed during client authentication. This property is required only if the validationScheme is 'ThumbprintMatch'.
 * @property validationScheme The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
 */
public data class ClientCertificateAuthenticationResponse(
    public val allowedThumbprints: List<String>? = null,
    public val validationScheme: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ClientCertificateAuthenticationResponse): ClientCertificateAuthenticationResponse = ClientCertificateAuthenticationResponse(
            allowedThumbprints = javaType.allowedThumbprints().map({ args0 -> args0 }),
            validationScheme = javaType.validationScheme().map({ args0 -> args0 }).orElse(null),
        )
    }
}
