@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ConnectionState information.
 * @property actionsRequired Actions required (if any).
 * @property description Description of the connection state.
 * @property status Status of the connection.
 */
public data class ConnectionStateResponse(
    public val actionsRequired: String? = null,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ConnectionStateResponse): ConnectionStateResponse = ConnectionStateResponse(
            actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
