@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the delivery configuration information of the event subscription.
 * @property deliveryMode Delivery mode of the event subscription.
 * @property queue This property should be populated when deliveryMode is queue and represents information about the queue subscription.
 */
public data class DeliveryConfigurationResponse(
    public val deliveryMode: String? = null,
    public val queue: QueueInfoResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.DeliveryConfigurationResponse): DeliveryConfigurationResponse = DeliveryConfigurationResponse(
            deliveryMode = javaType.deliveryMode().map({ args0 -> args0 }).orElse(null),
            queue = javaType.queue().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.QueueInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
