@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Filter for the Event Subscription.
 * @property advancedFilters An array of advanced filters that are used for filtering event subscriptions.
 * @property enableAdvancedFilteringOnArrays Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
 * @property includedEventTypes A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
 * @property isSubjectCaseSensitive Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
 * should be compared in a case sensitive manner.
 * @property subjectBeginsWith An optional string to filter events for an event subscription based on a resource path prefix.
 * The format of this depends on the publisher of the events.
 * Wildcard characters are not supported in this path.
 * @property subjectEndsWith An optional string to filter events for an event subscription based on a resource path suffix.
 * Wildcard characters are not supported in this path.
 */
public data class EventSubscriptionFilterResponse(
    public val advancedFilters: List<Any>? = null,
    public val enableAdvancedFilteringOnArrays: Boolean? = null,
    public val includedEventTypes: List<String>? = null,
    public val isSubjectCaseSensitive: Boolean? = null,
    public val subjectBeginsWith: String? = null,
    public val subjectEndsWith: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.EventSubscriptionFilterResponse): EventSubscriptionFilterResponse = EventSubscriptionFilterResponse(
            advancedFilters = javaType.advancedFilters().map({ args0 -> args0 }),
            enableAdvancedFilteringOnArrays = javaType.enableAdvancedFilteringOnArrays().map({ args0 ->
                args0
            }).orElse(null),
            includedEventTypes = javaType.includedEventTypes().map({ args0 -> args0 }),
            isSubjectCaseSensitive = javaType.isSubjectCaseSensitive().map({ args0 -> args0 }).orElse(null),
            subjectBeginsWith = javaType.subjectBeginsWith().map({ args0 -> args0 }).orElse(null),
            subjectEndsWith = javaType.subjectEndsWith().map({ args0 -> args0 }).orElse(null),
        )
    }
}
