@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The identity information with the event subscription.
 * @property type The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
 * @property userAssignedIdentity The user identity associated with the resource.
 */
public data class EventSubscriptionIdentityResponse(
    public val type: String? = null,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.EventSubscriptionIdentityResponse): EventSubscriptionIdentityResponse = EventSubscriptionIdentityResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
