@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The event type information for Channels.
 * @property inlineEventTypes A collection of inline event types for the resource. The inline event type keys are of type string which represents the name of the event.
 * An example of a valid inline event name is "Contoso.OrderCreated".
 * The inline event type values are of type InlineEventProperties and will contain additional information for every inline event type.
 * @property kind The kind of event type used.
 */
public data class EventTypeInfoResponse(
    public val inlineEventTypes: Map<String, InlineEventPropertiesResponse>? = null,
    public val kind: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.EventTypeInfoResponse): EventTypeInfoResponse = EventTypeInfoResponse(
            inlineEventTypes = javaType.inlineEventTypes().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.eventgrid.kotlin.outputs.InlineEventPropertiesResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
        )
    }
}
