@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The CA Certificate resource.
 * @property description Description for the CA Certificate resource.
 * @property encodedCertificate Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
 * @property expiryTimeInUtc Certificate expiry time in UTC. This is a read-only field.
 * @property id Fully qualified identifier of the resource.
 * @property issueTimeInUtc Certificate issue time in UTC. This is a read-only field.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the CA Certificate resource.
 * @property systemData The system metadata relating to the CaCertificate resource.
 * @property type Type of the resource.
 */
public data class GetCaCertificateResult(
    public val description: String? = null,
    public val encodedCertificate: String? = null,
    public val expiryTimeInUtc: String,
    public val id: String,
    public val issueTimeInUtc: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetCaCertificateResult): GetCaCertificateResult = GetCaCertificateResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            encodedCertificate = javaType.encodedCertificate().map({ args0 -> args0 }).orElse(null),
            expiryTimeInUtc = javaType.expiryTimeInUtc(),
            id = javaType.id(),
            issueTimeInUtc = javaType.issueTimeInUtc(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
