@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Channel info.
 * @property channelType The type of the event channel which represents the direction flow of events.
 * @property expirationTimeIfNotActivatedUtc Expiration time of the channel. If this timer expires while the corresponding partner topic is never activated,
 * the channel and corresponding partner topic are deleted.
 * @property id Fully qualified identifier of the resource.
 * @property messageForActivation Context or helpful message that can be used during the approval process by the subscriber.
 * @property name Name of the resource.
 * @property partnerTopicInfo This property should be populated when channelType is PartnerTopic and represents information about the partner topic resource corresponding to the channel.
 * @property provisioningState Provisioning state of the channel.
 * @property readinessState The readiness state of the corresponding partner topic.
 * @property systemData The system metadata relating to Channel resource.
 * @property type Type of the resource.
 */
public data class GetChannelResult(
    public val channelType: String? = null,
    public val expirationTimeIfNotActivatedUtc: String? = null,
    public val id: String,
    public val messageForActivation: String? = null,
    public val name: String,
    public val partnerTopicInfo: PartnerTopicInfoResponse? = null,
    public val provisioningState: String? = null,
    public val readinessState: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetChannelResult): GetChannelResult = GetChannelResult(
            channelType = javaType.channelType().map({ args0 -> args0 }).orElse(null),
            expirationTimeIfNotActivatedUtc = javaType.expirationTimeIfNotActivatedUtc().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            messageForActivation = javaType.messageForActivation().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            partnerTopicInfo = javaType.partnerTopicInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.PartnerTopicInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            readinessState = javaType.readinessState().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
