@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Client group resource.
 * @property description Description for the Client Group resource.
 * @property id Fully qualified identifier of the resource.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the ClientGroup resource.
 * @property query The grouping query for the clients.
 * Example : attributes.keyName IN ['a', 'b', 'c'].
 * @property systemData The system metadata relating to the ClientGroup resource.
 * @property type Type of the resource.
 */
public data class GetClientGroupResult(
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val query: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetClientGroupResult): GetClientGroupResult = GetClientGroupResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
