@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The Client resource.
 * @property attributes Attributes for the client. Supported values are int, bool, string, string[].
 * Example:
 * "attributes": { "room": "345", "floor": 12, "deviceTypes": ["Fan", "Light"] }
 * @property authentication Authentication information for the client.
 * @property authenticationName The name presented by the client for authentication. The default value is the name of the resource.
 * @property clientCertificateAuthentication The client certificate authentication information.
 * @property description Description for the Client resource.
 * @property id Fully qualified identifier of the resource.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the Client resource.
 * @property state Indicates if the client is enabled or not. Default value is Enabled.
 * @property systemData The system metadata relating to the Client resource.
 * @property type Type of the resource.
 */
public data class GetClientResult(
    public val attributes: Any? = null,
    public val authentication: ClientAuthenticationResponse? = null,
    public val authenticationName: String? = null,
    public val clientCertificateAuthentication: ClientCertificateAuthenticationResponse? = null,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val state: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetClientResult): GetClientResult = GetClientResult(
            attributes = javaType.attributes().map({ args0 -> args0 }).orElse(null),
            authentication = javaType.authentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            authenticationName = javaType.authenticationName().map({ args0 -> args0 }).orElse(null),
            clientCertificateAuthentication = javaType.clientCertificateAuthentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.ClientCertificateAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
